package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsCapitalChangeType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsDividendsType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsEarningsType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsEquityOfferingsType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsMergersAcquisitionsType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsNominalValueType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsSharesType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsStandardEventsType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.CorporateActionsVotingRightsType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ShareAmountChoice;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ShareAmountType;
import thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ReportDateRangeType", 
    "PreviousDays", 
    "QueryStartDate", 
    "NextDays", 
    "QueryEndDate", 
    "PendingEventsHours", 
    "PendingEventsMinutes", 
    "IncludeInstrumentsWithNoEvents", 
    "IncludeNullDates", 
    "ExcludeDeletedEvents", 
    "IncludeCapitalChangeEvents", 
    "IncludeDividendEvents", 
    "IncludeEarningsEvents", 
    "IncludeMergersAndAcquisitionsEvents", 
    "IncludeNominalValueEvents", 
    "IncludePublicEquityOfferingsEvents", 
    "IncludeSharesOutstandingEvents", 
    "IncludeVotingRightsEvents", 
    "CorporateActionsCapitalChangeType", 
    "CorporateActionsDividendsType", 
    "CorporateActionsEarningsType", 
    "CorporateActionsEquityOfferingsType", 
    "CorporateActionsMergersAcquisitionsType", 
    "CorporateActionsNominalValueType", 
    "CorporateActionsSharesType", 
    "CorporateActionsStandardEventsType", 
    "CorporateActionsVotingRightsType", 
    "ShareAmountChoice", 
    "ShareAmountTypes"})
public class CorporateActionsStandardCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("PreviousDays")
    protected Integer previousDays;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("NextDays")
    protected Integer nextDays;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("PendingEventsHours")
    protected Integer pendingEventsHours;

    @JsonProperty("PendingEventsMinutes")
    protected Integer pendingEventsMinutes;

    @JsonProperty("IncludeInstrumentsWithNoEvents")
    protected Boolean includeInstrumentsWithNoEvents;

    @JsonProperty("IncludeNullDates")
    protected Boolean includeNullDates;

    @JsonProperty("ExcludeDeletedEvents")
    protected Boolean excludeDeletedEvents;

    @JsonProperty("IncludeCapitalChangeEvents")
    protected Boolean includeCapitalChangeEvents;

    @JsonProperty("IncludeDividendEvents")
    protected Boolean includeDividendEvents;

    @JsonProperty("IncludeEarningsEvents")
    protected Boolean includeEarningsEvents;

    @JsonProperty("IncludeMergersAndAcquisitionsEvents")
    protected Boolean includeMergersAndAcquisitionsEvents;

    @JsonProperty("IncludeNominalValueEvents")
    protected Boolean includeNominalValueEvents;

    @JsonProperty("IncludePublicEquityOfferingsEvents")
    protected Boolean includePublicEquityOfferingsEvents;

    @JsonProperty("IncludeSharesOutstandingEvents")
    protected Boolean includeSharesOutstandingEvents;

    @JsonProperty("IncludeVotingRightsEvents")
    protected Boolean includeVotingRightsEvents;

    @JsonProperty("CorporateActionsCapitalChangeType")
    protected CorporateActionsCapitalChangeType corporateActionsCapitalChangeType;

    @JsonProperty("CorporateActionsDividendsType")
    protected CorporateActionsDividendsType corporateActionsDividendsType;

    @JsonProperty("CorporateActionsEarningsType")
    protected CorporateActionsEarningsType corporateActionsEarningsType;

    @JsonProperty("CorporateActionsEquityOfferingsType")
    protected CorporateActionsEquityOfferingsType corporateActionsEquityOfferingsType;

    @JsonProperty("CorporateActionsMergersAcquisitionsType")
    protected CorporateActionsMergersAcquisitionsType corporateActionsMergersAcquisitionsType;

    @JsonProperty("CorporateActionsNominalValueType")
    protected CorporateActionsNominalValueType corporateActionsNominalValueType;

    @JsonProperty("CorporateActionsSharesType")
    protected CorporateActionsSharesType corporateActionsSharesType;

    @JsonProperty("CorporateActionsStandardEventsType")
    protected CorporateActionsStandardEventsType corporateActionsStandardEventsType;

    @JsonProperty("CorporateActionsVotingRightsType")
    protected CorporateActionsVotingRightsType corporateActionsVotingRightsType;

    @JsonProperty("ShareAmountChoice")
    protected ShareAmountChoice shareAmountChoice;

    @JsonProperty("ShareAmountTypes")
    protected List<ShareAmountType> shareAmountTypes;

    @JsonProperty("ShareAmountTypes@nextLink")
    protected String shareAmountTypesNextLink;

    protected CorporateActionsStandardCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition";
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public CorporateActionsStandardCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="PreviousDays")
    @JsonIgnore
    public Optional<Integer> getPreviousDays() {
        return Optional.ofNullable(previousDays);
    }

    public CorporateActionsStandardCondition withPreviousDays(Integer previousDays) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.previousDays = previousDays;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public CorporateActionsStandardCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="NextDays")
    @JsonIgnore
    public Optional<Integer> getNextDays() {
        return Optional.ofNullable(nextDays);
    }

    public CorporateActionsStandardCondition withNextDays(Integer nextDays) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.nextDays = nextDays;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public CorporateActionsStandardCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="PendingEventsHours")
    @JsonIgnore
    public Optional<Integer> getPendingEventsHours() {
        return Optional.ofNullable(pendingEventsHours);
    }

    public CorporateActionsStandardCondition withPendingEventsHours(Integer pendingEventsHours) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.pendingEventsHours = pendingEventsHours;
        return _x;
    }

    @Property(name="PendingEventsMinutes")
    @JsonIgnore
    public Optional<Integer> getPendingEventsMinutes() {
        return Optional.ofNullable(pendingEventsMinutes);
    }

    public CorporateActionsStandardCondition withPendingEventsMinutes(Integer pendingEventsMinutes) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.pendingEventsMinutes = pendingEventsMinutes;
        return _x;
    }

    @Property(name="IncludeInstrumentsWithNoEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeInstrumentsWithNoEvents() {
        return Optional.ofNullable(includeInstrumentsWithNoEvents);
    }

    public CorporateActionsStandardCondition withIncludeInstrumentsWithNoEvents(Boolean includeInstrumentsWithNoEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeInstrumentsWithNoEvents = includeInstrumentsWithNoEvents;
        return _x;
    }

    @Property(name="IncludeNullDates")
    @JsonIgnore
    public Optional<Boolean> getIncludeNullDates() {
        return Optional.ofNullable(includeNullDates);
    }

    public CorporateActionsStandardCondition withIncludeNullDates(Boolean includeNullDates) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeNullDates = includeNullDates;
        return _x;
    }

    @Property(name="ExcludeDeletedEvents")
    @JsonIgnore
    public Optional<Boolean> getExcludeDeletedEvents() {
        return Optional.ofNullable(excludeDeletedEvents);
    }

    public CorporateActionsStandardCondition withExcludeDeletedEvents(Boolean excludeDeletedEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.excludeDeletedEvents = excludeDeletedEvents;
        return _x;
    }

    @Property(name="IncludeCapitalChangeEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeCapitalChangeEvents() {
        return Optional.ofNullable(includeCapitalChangeEvents);
    }

    public CorporateActionsStandardCondition withIncludeCapitalChangeEvents(Boolean includeCapitalChangeEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeCapitalChangeEvents = includeCapitalChangeEvents;
        return _x;
    }

    @Property(name="IncludeDividendEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeDividendEvents() {
        return Optional.ofNullable(includeDividendEvents);
    }

    public CorporateActionsStandardCondition withIncludeDividendEvents(Boolean includeDividendEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeDividendEvents = includeDividendEvents;
        return _x;
    }

    @Property(name="IncludeEarningsEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeEarningsEvents() {
        return Optional.ofNullable(includeEarningsEvents);
    }

    public CorporateActionsStandardCondition withIncludeEarningsEvents(Boolean includeEarningsEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeEarningsEvents = includeEarningsEvents;
        return _x;
    }

    @Property(name="IncludeMergersAndAcquisitionsEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeMergersAndAcquisitionsEvents() {
        return Optional.ofNullable(includeMergersAndAcquisitionsEvents);
    }

    public CorporateActionsStandardCondition withIncludeMergersAndAcquisitionsEvents(Boolean includeMergersAndAcquisitionsEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeMergersAndAcquisitionsEvents = includeMergersAndAcquisitionsEvents;
        return _x;
    }

    @Property(name="IncludeNominalValueEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeNominalValueEvents() {
        return Optional.ofNullable(includeNominalValueEvents);
    }

    public CorporateActionsStandardCondition withIncludeNominalValueEvents(Boolean includeNominalValueEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeNominalValueEvents = includeNominalValueEvents;
        return _x;
    }

    @Property(name="IncludePublicEquityOfferingsEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludePublicEquityOfferingsEvents() {
        return Optional.ofNullable(includePublicEquityOfferingsEvents);
    }

    public CorporateActionsStandardCondition withIncludePublicEquityOfferingsEvents(Boolean includePublicEquityOfferingsEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includePublicEquityOfferingsEvents = includePublicEquityOfferingsEvents;
        return _x;
    }

    @Property(name="IncludeSharesOutstandingEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeSharesOutstandingEvents() {
        return Optional.ofNullable(includeSharesOutstandingEvents);
    }

    public CorporateActionsStandardCondition withIncludeSharesOutstandingEvents(Boolean includeSharesOutstandingEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeSharesOutstandingEvents = includeSharesOutstandingEvents;
        return _x;
    }

    @Property(name="IncludeVotingRightsEvents")
    @JsonIgnore
    public Optional<Boolean> getIncludeVotingRightsEvents() {
        return Optional.ofNullable(includeVotingRightsEvents);
    }

    public CorporateActionsStandardCondition withIncludeVotingRightsEvents(Boolean includeVotingRightsEvents) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.includeVotingRightsEvents = includeVotingRightsEvents;
        return _x;
    }

    @Property(name="CorporateActionsCapitalChangeType")
    @JsonIgnore
    public Optional<CorporateActionsCapitalChangeType> getCorporateActionsCapitalChangeType() {
        return Optional.ofNullable(corporateActionsCapitalChangeType);
    }

    public CorporateActionsStandardCondition withCorporateActionsCapitalChangeType(CorporateActionsCapitalChangeType corporateActionsCapitalChangeType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsCapitalChangeType = corporateActionsCapitalChangeType;
        return _x;
    }

    @Property(name="CorporateActionsDividendsType")
    @JsonIgnore
    public Optional<CorporateActionsDividendsType> getCorporateActionsDividendsType() {
        return Optional.ofNullable(corporateActionsDividendsType);
    }

    public CorporateActionsStandardCondition withCorporateActionsDividendsType(CorporateActionsDividendsType corporateActionsDividendsType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsDividendsType = corporateActionsDividendsType;
        return _x;
    }

    @Property(name="CorporateActionsEarningsType")
    @JsonIgnore
    public Optional<CorporateActionsEarningsType> getCorporateActionsEarningsType() {
        return Optional.ofNullable(corporateActionsEarningsType);
    }

    public CorporateActionsStandardCondition withCorporateActionsEarningsType(CorporateActionsEarningsType corporateActionsEarningsType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsEarningsType = corporateActionsEarningsType;
        return _x;
    }

    @Property(name="CorporateActionsEquityOfferingsType")
    @JsonIgnore
    public Optional<CorporateActionsEquityOfferingsType> getCorporateActionsEquityOfferingsType() {
        return Optional.ofNullable(corporateActionsEquityOfferingsType);
    }

    public CorporateActionsStandardCondition withCorporateActionsEquityOfferingsType(CorporateActionsEquityOfferingsType corporateActionsEquityOfferingsType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsEquityOfferingsType = corporateActionsEquityOfferingsType;
        return _x;
    }

    @Property(name="CorporateActionsMergersAcquisitionsType")
    @JsonIgnore
    public Optional<CorporateActionsMergersAcquisitionsType> getCorporateActionsMergersAcquisitionsType() {
        return Optional.ofNullable(corporateActionsMergersAcquisitionsType);
    }

    public CorporateActionsStandardCondition withCorporateActionsMergersAcquisitionsType(CorporateActionsMergersAcquisitionsType corporateActionsMergersAcquisitionsType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsMergersAcquisitionsType = corporateActionsMergersAcquisitionsType;
        return _x;
    }

    @Property(name="CorporateActionsNominalValueType")
    @JsonIgnore
    public Optional<CorporateActionsNominalValueType> getCorporateActionsNominalValueType() {
        return Optional.ofNullable(corporateActionsNominalValueType);
    }

    public CorporateActionsStandardCondition withCorporateActionsNominalValueType(CorporateActionsNominalValueType corporateActionsNominalValueType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsNominalValueType = corporateActionsNominalValueType;
        return _x;
    }

    @Property(name="CorporateActionsSharesType")
    @JsonIgnore
    public Optional<CorporateActionsSharesType> getCorporateActionsSharesType() {
        return Optional.ofNullable(corporateActionsSharesType);
    }

    public CorporateActionsStandardCondition withCorporateActionsSharesType(CorporateActionsSharesType corporateActionsSharesType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsSharesType = corporateActionsSharesType;
        return _x;
    }

    @Property(name="CorporateActionsStandardEventsType")
    @JsonIgnore
    public Optional<CorporateActionsStandardEventsType> getCorporateActionsStandardEventsType() {
        return Optional.ofNullable(corporateActionsStandardEventsType);
    }

    public CorporateActionsStandardCondition withCorporateActionsStandardEventsType(CorporateActionsStandardEventsType corporateActionsStandardEventsType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsStandardEventsType = corporateActionsStandardEventsType;
        return _x;
    }

    @Property(name="CorporateActionsVotingRightsType")
    @JsonIgnore
    public Optional<CorporateActionsVotingRightsType> getCorporateActionsVotingRightsType() {
        return Optional.ofNullable(corporateActionsVotingRightsType);
    }

    public CorporateActionsStandardCondition withCorporateActionsVotingRightsType(CorporateActionsVotingRightsType corporateActionsVotingRightsType) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.corporateActionsVotingRightsType = corporateActionsVotingRightsType;
        return _x;
    }

    @Property(name="ShareAmountChoice")
    @JsonIgnore
    public Optional<ShareAmountChoice> getShareAmountChoice() {
        return Optional.ofNullable(shareAmountChoice);
    }

    public CorporateActionsStandardCondition withShareAmountChoice(ShareAmountChoice shareAmountChoice) {
        CorporateActionsStandardCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition");
        _x.shareAmountChoice = shareAmountChoice;
        return _x;
    }

    @Property(name="ShareAmountTypes")
    @JsonIgnore
    public CollectionPage<ShareAmountType> getShareAmountTypes() {
        return new CollectionPage<ShareAmountType>(contextPath, ShareAmountType.class, shareAmountTypes, Optional.ofNullable(shareAmountTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ReportDateRangeType reportDateRangeType;
        private Integer previousDays;
        private OffsetDateTime queryStartDate;
        private Integer nextDays;
        private OffsetDateTime queryEndDate;
        private Integer pendingEventsHours;
        private Integer pendingEventsMinutes;
        private Boolean includeInstrumentsWithNoEvents;
        private Boolean includeNullDates;
        private Boolean excludeDeletedEvents;
        private Boolean includeCapitalChangeEvents;
        private Boolean includeDividendEvents;
        private Boolean includeEarningsEvents;
        private Boolean includeMergersAndAcquisitionsEvents;
        private Boolean includeNominalValueEvents;
        private Boolean includePublicEquityOfferingsEvents;
        private Boolean includeSharesOutstandingEvents;
        private Boolean includeVotingRightsEvents;
        private CorporateActionsCapitalChangeType corporateActionsCapitalChangeType;
        private CorporateActionsDividendsType corporateActionsDividendsType;
        private CorporateActionsEarningsType corporateActionsEarningsType;
        private CorporateActionsEquityOfferingsType corporateActionsEquityOfferingsType;
        private CorporateActionsMergersAcquisitionsType corporateActionsMergersAcquisitionsType;
        private CorporateActionsNominalValueType corporateActionsNominalValueType;
        private CorporateActionsSharesType corporateActionsSharesType;
        private CorporateActionsStandardEventsType corporateActionsStandardEventsType;
        private CorporateActionsVotingRightsType corporateActionsVotingRightsType;
        private ShareAmountChoice shareAmountChoice;
        private List<ShareAmountType> shareAmountTypes;
        private String shareAmountTypesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder previousDays(Integer previousDays) {
            this.previousDays = previousDays;
            this.changedFields = changedFields.add("PreviousDays");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder nextDays(Integer nextDays) {
            this.nextDays = nextDays;
            this.changedFields = changedFields.add("NextDays");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder pendingEventsHours(Integer pendingEventsHours) {
            this.pendingEventsHours = pendingEventsHours;
            this.changedFields = changedFields.add("PendingEventsHours");
            return this;
        }

        public Builder pendingEventsMinutes(Integer pendingEventsMinutes) {
            this.pendingEventsMinutes = pendingEventsMinutes;
            this.changedFields = changedFields.add("PendingEventsMinutes");
            return this;
        }

        public Builder includeInstrumentsWithNoEvents(Boolean includeInstrumentsWithNoEvents) {
            this.includeInstrumentsWithNoEvents = includeInstrumentsWithNoEvents;
            this.changedFields = changedFields.add("IncludeInstrumentsWithNoEvents");
            return this;
        }

        public Builder includeNullDates(Boolean includeNullDates) {
            this.includeNullDates = includeNullDates;
            this.changedFields = changedFields.add("IncludeNullDates");
            return this;
        }

        public Builder excludeDeletedEvents(Boolean excludeDeletedEvents) {
            this.excludeDeletedEvents = excludeDeletedEvents;
            this.changedFields = changedFields.add("ExcludeDeletedEvents");
            return this;
        }

        public Builder includeCapitalChangeEvents(Boolean includeCapitalChangeEvents) {
            this.includeCapitalChangeEvents = includeCapitalChangeEvents;
            this.changedFields = changedFields.add("IncludeCapitalChangeEvents");
            return this;
        }

        public Builder includeDividendEvents(Boolean includeDividendEvents) {
            this.includeDividendEvents = includeDividendEvents;
            this.changedFields = changedFields.add("IncludeDividendEvents");
            return this;
        }

        public Builder includeEarningsEvents(Boolean includeEarningsEvents) {
            this.includeEarningsEvents = includeEarningsEvents;
            this.changedFields = changedFields.add("IncludeEarningsEvents");
            return this;
        }

        public Builder includeMergersAndAcquisitionsEvents(Boolean includeMergersAndAcquisitionsEvents) {
            this.includeMergersAndAcquisitionsEvents = includeMergersAndAcquisitionsEvents;
            this.changedFields = changedFields.add("IncludeMergersAndAcquisitionsEvents");
            return this;
        }

        public Builder includeNominalValueEvents(Boolean includeNominalValueEvents) {
            this.includeNominalValueEvents = includeNominalValueEvents;
            this.changedFields = changedFields.add("IncludeNominalValueEvents");
            return this;
        }

        public Builder includePublicEquityOfferingsEvents(Boolean includePublicEquityOfferingsEvents) {
            this.includePublicEquityOfferingsEvents = includePublicEquityOfferingsEvents;
            this.changedFields = changedFields.add("IncludePublicEquityOfferingsEvents");
            return this;
        }

        public Builder includeSharesOutstandingEvents(Boolean includeSharesOutstandingEvents) {
            this.includeSharesOutstandingEvents = includeSharesOutstandingEvents;
            this.changedFields = changedFields.add("IncludeSharesOutstandingEvents");
            return this;
        }

        public Builder includeVotingRightsEvents(Boolean includeVotingRightsEvents) {
            this.includeVotingRightsEvents = includeVotingRightsEvents;
            this.changedFields = changedFields.add("IncludeVotingRightsEvents");
            return this;
        }

        public Builder corporateActionsCapitalChangeType(CorporateActionsCapitalChangeType corporateActionsCapitalChangeType) {
            this.corporateActionsCapitalChangeType = corporateActionsCapitalChangeType;
            this.changedFields = changedFields.add("CorporateActionsCapitalChangeType");
            return this;
        }

        public Builder corporateActionsDividendsType(CorporateActionsDividendsType corporateActionsDividendsType) {
            this.corporateActionsDividendsType = corporateActionsDividendsType;
            this.changedFields = changedFields.add("CorporateActionsDividendsType");
            return this;
        }

        public Builder corporateActionsEarningsType(CorporateActionsEarningsType corporateActionsEarningsType) {
            this.corporateActionsEarningsType = corporateActionsEarningsType;
            this.changedFields = changedFields.add("CorporateActionsEarningsType");
            return this;
        }

        public Builder corporateActionsEquityOfferingsType(CorporateActionsEquityOfferingsType corporateActionsEquityOfferingsType) {
            this.corporateActionsEquityOfferingsType = corporateActionsEquityOfferingsType;
            this.changedFields = changedFields.add("CorporateActionsEquityOfferingsType");
            return this;
        }

        public Builder corporateActionsMergersAcquisitionsType(CorporateActionsMergersAcquisitionsType corporateActionsMergersAcquisitionsType) {
            this.corporateActionsMergersAcquisitionsType = corporateActionsMergersAcquisitionsType;
            this.changedFields = changedFields.add("CorporateActionsMergersAcquisitionsType");
            return this;
        }

        public Builder corporateActionsNominalValueType(CorporateActionsNominalValueType corporateActionsNominalValueType) {
            this.corporateActionsNominalValueType = corporateActionsNominalValueType;
            this.changedFields = changedFields.add("CorporateActionsNominalValueType");
            return this;
        }

        public Builder corporateActionsSharesType(CorporateActionsSharesType corporateActionsSharesType) {
            this.corporateActionsSharesType = corporateActionsSharesType;
            this.changedFields = changedFields.add("CorporateActionsSharesType");
            return this;
        }

        public Builder corporateActionsStandardEventsType(CorporateActionsStandardEventsType corporateActionsStandardEventsType) {
            this.corporateActionsStandardEventsType = corporateActionsStandardEventsType;
            this.changedFields = changedFields.add("CorporateActionsStandardEventsType");
            return this;
        }

        public Builder corporateActionsVotingRightsType(CorporateActionsVotingRightsType corporateActionsVotingRightsType) {
            this.corporateActionsVotingRightsType = corporateActionsVotingRightsType;
            this.changedFields = changedFields.add("CorporateActionsVotingRightsType");
            return this;
        }

        public Builder shareAmountChoice(ShareAmountChoice shareAmountChoice) {
            this.shareAmountChoice = shareAmountChoice;
            this.changedFields = changedFields.add("ShareAmountChoice");
            return this;
        }

        public Builder shareAmountTypes(List<ShareAmountType> shareAmountTypes) {
            this.shareAmountTypes = shareAmountTypes;
            this.changedFields = changedFields.add("ShareAmountTypes");
            return this;
        }

        public Builder shareAmountTypesNextLink(String shareAmountTypesNextLink) {
            this.shareAmountTypesNextLink = shareAmountTypesNextLink;
            this.changedFields = changedFields.add("ShareAmountTypes");
            return this;
        }

        public CorporateActionsStandardCondition build() {
            CorporateActionsStandardCondition _x = new CorporateActionsStandardCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.CorporateActionsStandardCondition";
            _x.reportDateRangeType = reportDateRangeType;
            _x.previousDays = previousDays;
            _x.queryStartDate = queryStartDate;
            _x.nextDays = nextDays;
            _x.queryEndDate = queryEndDate;
            _x.pendingEventsHours = pendingEventsHours;
            _x.pendingEventsMinutes = pendingEventsMinutes;
            _x.includeInstrumentsWithNoEvents = includeInstrumentsWithNoEvents;
            _x.includeNullDates = includeNullDates;
            _x.excludeDeletedEvents = excludeDeletedEvents;
            _x.includeCapitalChangeEvents = includeCapitalChangeEvents;
            _x.includeDividendEvents = includeDividendEvents;
            _x.includeEarningsEvents = includeEarningsEvents;
            _x.includeMergersAndAcquisitionsEvents = includeMergersAndAcquisitionsEvents;
            _x.includeNominalValueEvents = includeNominalValueEvents;
            _x.includePublicEquityOfferingsEvents = includePublicEquityOfferingsEvents;
            _x.includeSharesOutstandingEvents = includeSharesOutstandingEvents;
            _x.includeVotingRightsEvents = includeVotingRightsEvents;
            _x.corporateActionsCapitalChangeType = corporateActionsCapitalChangeType;
            _x.corporateActionsDividendsType = corporateActionsDividendsType;
            _x.corporateActionsEarningsType = corporateActionsEarningsType;
            _x.corporateActionsEquityOfferingsType = corporateActionsEquityOfferingsType;
            _x.corporateActionsMergersAcquisitionsType = corporateActionsMergersAcquisitionsType;
            _x.corporateActionsNominalValueType = corporateActionsNominalValueType;
            _x.corporateActionsSharesType = corporateActionsSharesType;
            _x.corporateActionsStandardEventsType = corporateActionsStandardEventsType;
            _x.corporateActionsVotingRightsType = corporateActionsVotingRightsType;
            _x.shareAmountChoice = shareAmountChoice;
            _x.shareAmountTypes = shareAmountTypes;
            _x.shareAmountTypesNextLink = shareAmountTypesNextLink;
            return _x;
        }
    }

    private CorporateActionsStandardCondition _copy() {
        CorporateActionsStandardCondition _x = new CorporateActionsStandardCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportDateRangeType = reportDateRangeType;
        _x.previousDays = previousDays;
        _x.queryStartDate = queryStartDate;
        _x.nextDays = nextDays;
        _x.queryEndDate = queryEndDate;
        _x.pendingEventsHours = pendingEventsHours;
        _x.pendingEventsMinutes = pendingEventsMinutes;
        _x.includeInstrumentsWithNoEvents = includeInstrumentsWithNoEvents;
        _x.includeNullDates = includeNullDates;
        _x.excludeDeletedEvents = excludeDeletedEvents;
        _x.includeCapitalChangeEvents = includeCapitalChangeEvents;
        _x.includeDividendEvents = includeDividendEvents;
        _x.includeEarningsEvents = includeEarningsEvents;
        _x.includeMergersAndAcquisitionsEvents = includeMergersAndAcquisitionsEvents;
        _x.includeNominalValueEvents = includeNominalValueEvents;
        _x.includePublicEquityOfferingsEvents = includePublicEquityOfferingsEvents;
        _x.includeSharesOutstandingEvents = includeSharesOutstandingEvents;
        _x.includeVotingRightsEvents = includeVotingRightsEvents;
        _x.corporateActionsCapitalChangeType = corporateActionsCapitalChangeType;
        _x.corporateActionsDividendsType = corporateActionsDividendsType;
        _x.corporateActionsEarningsType = corporateActionsEarningsType;
        _x.corporateActionsEquityOfferingsType = corporateActionsEquityOfferingsType;
        _x.corporateActionsMergersAcquisitionsType = corporateActionsMergersAcquisitionsType;
        _x.corporateActionsNominalValueType = corporateActionsNominalValueType;
        _x.corporateActionsSharesType = corporateActionsSharesType;
        _x.corporateActionsStandardEventsType = corporateActionsStandardEventsType;
        _x.corporateActionsVotingRightsType = corporateActionsVotingRightsType;
        _x.shareAmountChoice = shareAmountChoice;
        _x.shareAmountTypes = shareAmountTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CorporateActionsStandardCondition[");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("PreviousDays=");
        b.append(this.previousDays);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("NextDays=");
        b.append(this.nextDays);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("PendingEventsHours=");
        b.append(this.pendingEventsHours);
        b.append(", ");
        b.append("PendingEventsMinutes=");
        b.append(this.pendingEventsMinutes);
        b.append(", ");
        b.append("IncludeInstrumentsWithNoEvents=");
        b.append(this.includeInstrumentsWithNoEvents);
        b.append(", ");
        b.append("IncludeNullDates=");
        b.append(this.includeNullDates);
        b.append(", ");
        b.append("ExcludeDeletedEvents=");
        b.append(this.excludeDeletedEvents);
        b.append(", ");
        b.append("IncludeCapitalChangeEvents=");
        b.append(this.includeCapitalChangeEvents);
        b.append(", ");
        b.append("IncludeDividendEvents=");
        b.append(this.includeDividendEvents);
        b.append(", ");
        b.append("IncludeEarningsEvents=");
        b.append(this.includeEarningsEvents);
        b.append(", ");
        b.append("IncludeMergersAndAcquisitionsEvents=");
        b.append(this.includeMergersAndAcquisitionsEvents);
        b.append(", ");
        b.append("IncludeNominalValueEvents=");
        b.append(this.includeNominalValueEvents);
        b.append(", ");
        b.append("IncludePublicEquityOfferingsEvents=");
        b.append(this.includePublicEquityOfferingsEvents);
        b.append(", ");
        b.append("IncludeSharesOutstandingEvents=");
        b.append(this.includeSharesOutstandingEvents);
        b.append(", ");
        b.append("IncludeVotingRightsEvents=");
        b.append(this.includeVotingRightsEvents);
        b.append(", ");
        b.append("CorporateActionsCapitalChangeType=");
        b.append(this.corporateActionsCapitalChangeType);
        b.append(", ");
        b.append("CorporateActionsDividendsType=");
        b.append(this.corporateActionsDividendsType);
        b.append(", ");
        b.append("CorporateActionsEarningsType=");
        b.append(this.corporateActionsEarningsType);
        b.append(", ");
        b.append("CorporateActionsEquityOfferingsType=");
        b.append(this.corporateActionsEquityOfferingsType);
        b.append(", ");
        b.append("CorporateActionsMergersAcquisitionsType=");
        b.append(this.corporateActionsMergersAcquisitionsType);
        b.append(", ");
        b.append("CorporateActionsNominalValueType=");
        b.append(this.corporateActionsNominalValueType);
        b.append(", ");
        b.append("CorporateActionsSharesType=");
        b.append(this.corporateActionsSharesType);
        b.append(", ");
        b.append("CorporateActionsStandardEventsType=");
        b.append(this.corporateActionsStandardEventsType);
        b.append(", ");
        b.append("CorporateActionsVotingRightsType=");
        b.append(this.corporateActionsVotingRightsType);
        b.append(", ");
        b.append("ShareAmountChoice=");
        b.append(this.shareAmountChoice);
        b.append(", ");
        b.append("ShareAmountTypes=");
        b.append(this.shareAmountTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
