package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ReportDateRangeType", 
    "StartDate", 
    "EndDate", 
    "QueryStartDate", 
    "QueryEndDate", 
    "DaysAgo", 
    "RelativeStartDaysAgo", 
    "RelativeEndDaysAgo"})
public class ElektronTimeseriesCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("StartDate")
    protected OffsetDateTime startDate;

    @JsonProperty("EndDate")
    protected OffsetDateTime endDate;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("RelativeStartDaysAgo")
    protected Integer relativeStartDaysAgo;

    @JsonProperty("RelativeEndDaysAgo")
    protected Integer relativeEndDaysAgo;

    protected ElektronTimeseriesCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition";
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public ElektronTimeseriesCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        ElektronTimeseriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="StartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public ElektronTimeseriesCondition withStartDate(OffsetDateTime startDate) {
        ElektronTimeseriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="EndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public ElektronTimeseriesCondition withEndDate(OffsetDateTime endDate) {
        ElektronTimeseriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public ElektronTimeseriesCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        ElektronTimeseriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public ElektronTimeseriesCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        ElektronTimeseriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public ElektronTimeseriesCondition withDaysAgo(Integer daysAgo) {
        ElektronTimeseriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="RelativeStartDaysAgo")
    @JsonIgnore
    public Optional<Integer> getRelativeStartDaysAgo() {
        return Optional.ofNullable(relativeStartDaysAgo);
    }

    public ElektronTimeseriesCondition withRelativeStartDaysAgo(Integer relativeStartDaysAgo) {
        ElektronTimeseriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition");
        _x.relativeStartDaysAgo = relativeStartDaysAgo;
        return _x;
    }

    @Property(name="RelativeEndDaysAgo")
    @JsonIgnore
    public Optional<Integer> getRelativeEndDaysAgo() {
        return Optional.ofNullable(relativeEndDaysAgo);
    }

    public ElektronTimeseriesCondition withRelativeEndDaysAgo(Integer relativeEndDaysAgo) {
        ElektronTimeseriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition");
        _x.relativeEndDaysAgo = relativeEndDaysAgo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ReportDateRangeType reportDateRangeType;
        private OffsetDateTime startDate;
        private OffsetDateTime endDate;
        private OffsetDateTime queryStartDate;
        private OffsetDateTime queryEndDate;
        private Integer daysAgo;
        private Integer relativeStartDaysAgo;
        private Integer relativeEndDaysAgo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder startDate(OffsetDateTime startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("StartDate");
            return this;
        }

        public Builder endDate(OffsetDateTime endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("EndDate");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder relativeStartDaysAgo(Integer relativeStartDaysAgo) {
            this.relativeStartDaysAgo = relativeStartDaysAgo;
            this.changedFields = changedFields.add("RelativeStartDaysAgo");
            return this;
        }

        public Builder relativeEndDaysAgo(Integer relativeEndDaysAgo) {
            this.relativeEndDaysAgo = relativeEndDaysAgo;
            this.changedFields = changedFields.add("RelativeEndDaysAgo");
            return this;
        }

        public ElektronTimeseriesCondition build() {
            ElektronTimeseriesCondition _x = new ElektronTimeseriesCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ElektronTimeseriesCondition";
            _x.reportDateRangeType = reportDateRangeType;
            _x.startDate = startDate;
            _x.endDate = endDate;
            _x.queryStartDate = queryStartDate;
            _x.queryEndDate = queryEndDate;
            _x.daysAgo = daysAgo;
            _x.relativeStartDaysAgo = relativeStartDaysAgo;
            _x.relativeEndDaysAgo = relativeEndDaysAgo;
            return _x;
        }
    }

    private ElektronTimeseriesCondition _copy() {
        ElektronTimeseriesCondition _x = new ElektronTimeseriesCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportDateRangeType = reportDateRangeType;
        _x.startDate = startDate;
        _x.endDate = endDate;
        _x.queryStartDate = queryStartDate;
        _x.queryEndDate = queryEndDate;
        _x.daysAgo = daysAgo;
        _x.relativeStartDaysAgo = relativeStartDaysAgo;
        _x.relativeEndDaysAgo = relativeEndDaysAgo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ElektronTimeseriesCondition[");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("StartDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("EndDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("RelativeStartDaysAgo=");
        b.append(this.relativeStartDaysAgo);
        b.append(", ");
        b.append("RelativeEndDaysAgo=");
        b.append(this.relativeEndDaysAgo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
