package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.EstimateType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.RelativeFiscalYearType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.RelativeQuarterType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.RelativeSemiAnnualType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportCompanyType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;
import thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ReportDateRangeType", 
    "DaysAgo", 
    "FiscalYearFrom", 
    "QuarterFrom", 
    "SemiAnnualFrom", 
    "FiscalYearTo", 
    "QuarterTo", 
    "SemiAnnualTo", 
    "ReportCompanyType", 
    "EstimateTypes"})
public class EstimatesDetailCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("FiscalYearFrom")
    protected RelativeFiscalYearType fiscalYearFrom;

    @JsonProperty("QuarterFrom")
    protected RelativeQuarterType quarterFrom;

    @JsonProperty("SemiAnnualFrom")
    protected RelativeSemiAnnualType semiAnnualFrom;

    @JsonProperty("FiscalYearTo")
    protected RelativeFiscalYearType fiscalYearTo;

    @JsonProperty("QuarterTo")
    protected RelativeQuarterType quarterTo;

    @JsonProperty("SemiAnnualTo")
    protected RelativeSemiAnnualType semiAnnualTo;

    @JsonProperty("ReportCompanyType")
    protected ReportCompanyType reportCompanyType;

    @JsonProperty("EstimateTypes")
    protected List<EstimateType> estimateTypes;

    @JsonProperty("EstimateTypes@nextLink")
    protected String estimateTypesNextLink;

    protected EstimatesDetailCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition";
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public EstimatesDetailCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public EstimatesDetailCondition withDaysAgo(Integer daysAgo) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="FiscalYearFrom")
    @JsonIgnore
    public Optional<RelativeFiscalYearType> getFiscalYearFrom() {
        return Optional.ofNullable(fiscalYearFrom);
    }

    public EstimatesDetailCondition withFiscalYearFrom(RelativeFiscalYearType fiscalYearFrom) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.fiscalYearFrom = fiscalYearFrom;
        return _x;
    }

    @Property(name="QuarterFrom")
    @JsonIgnore
    public Optional<RelativeQuarterType> getQuarterFrom() {
        return Optional.ofNullable(quarterFrom);
    }

    public EstimatesDetailCondition withQuarterFrom(RelativeQuarterType quarterFrom) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.quarterFrom = quarterFrom;
        return _x;
    }

    @Property(name="SemiAnnualFrom")
    @JsonIgnore
    public Optional<RelativeSemiAnnualType> getSemiAnnualFrom() {
        return Optional.ofNullable(semiAnnualFrom);
    }

    public EstimatesDetailCondition withSemiAnnualFrom(RelativeSemiAnnualType semiAnnualFrom) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.semiAnnualFrom = semiAnnualFrom;
        return _x;
    }

    @Property(name="FiscalYearTo")
    @JsonIgnore
    public Optional<RelativeFiscalYearType> getFiscalYearTo() {
        return Optional.ofNullable(fiscalYearTo);
    }

    public EstimatesDetailCondition withFiscalYearTo(RelativeFiscalYearType fiscalYearTo) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.fiscalYearTo = fiscalYearTo;
        return _x;
    }

    @Property(name="QuarterTo")
    @JsonIgnore
    public Optional<RelativeQuarterType> getQuarterTo() {
        return Optional.ofNullable(quarterTo);
    }

    public EstimatesDetailCondition withQuarterTo(RelativeQuarterType quarterTo) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.quarterTo = quarterTo;
        return _x;
    }

    @Property(name="SemiAnnualTo")
    @JsonIgnore
    public Optional<RelativeSemiAnnualType> getSemiAnnualTo() {
        return Optional.ofNullable(semiAnnualTo);
    }

    public EstimatesDetailCondition withSemiAnnualTo(RelativeSemiAnnualType semiAnnualTo) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.semiAnnualTo = semiAnnualTo;
        return _x;
    }

    @Property(name="ReportCompanyType")
    @JsonIgnore
    public Optional<ReportCompanyType> getReportCompanyType() {
        return Optional.ofNullable(reportCompanyType);
    }

    public EstimatesDetailCondition withReportCompanyType(ReportCompanyType reportCompanyType) {
        EstimatesDetailCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition");
        _x.reportCompanyType = reportCompanyType;
        return _x;
    }

    @Property(name="EstimateTypes")
    @JsonIgnore
    public CollectionPage<EstimateType> getEstimateTypes() {
        return new CollectionPage<EstimateType>(contextPath, EstimateType.class, estimateTypes, Optional.ofNullable(estimateTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ReportDateRangeType reportDateRangeType;
        private Integer daysAgo;
        private RelativeFiscalYearType fiscalYearFrom;
        private RelativeQuarterType quarterFrom;
        private RelativeSemiAnnualType semiAnnualFrom;
        private RelativeFiscalYearType fiscalYearTo;
        private RelativeQuarterType quarterTo;
        private RelativeSemiAnnualType semiAnnualTo;
        private ReportCompanyType reportCompanyType;
        private List<EstimateType> estimateTypes;
        private String estimateTypesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder fiscalYearFrom(RelativeFiscalYearType fiscalYearFrom) {
            this.fiscalYearFrom = fiscalYearFrom;
            this.changedFields = changedFields.add("FiscalYearFrom");
            return this;
        }

        public Builder quarterFrom(RelativeQuarterType quarterFrom) {
            this.quarterFrom = quarterFrom;
            this.changedFields = changedFields.add("QuarterFrom");
            return this;
        }

        public Builder semiAnnualFrom(RelativeSemiAnnualType semiAnnualFrom) {
            this.semiAnnualFrom = semiAnnualFrom;
            this.changedFields = changedFields.add("SemiAnnualFrom");
            return this;
        }

        public Builder fiscalYearTo(RelativeFiscalYearType fiscalYearTo) {
            this.fiscalYearTo = fiscalYearTo;
            this.changedFields = changedFields.add("FiscalYearTo");
            return this;
        }

        public Builder quarterTo(RelativeQuarterType quarterTo) {
            this.quarterTo = quarterTo;
            this.changedFields = changedFields.add("QuarterTo");
            return this;
        }

        public Builder semiAnnualTo(RelativeSemiAnnualType semiAnnualTo) {
            this.semiAnnualTo = semiAnnualTo;
            this.changedFields = changedFields.add("SemiAnnualTo");
            return this;
        }

        public Builder reportCompanyType(ReportCompanyType reportCompanyType) {
            this.reportCompanyType = reportCompanyType;
            this.changedFields = changedFields.add("ReportCompanyType");
            return this;
        }

        public Builder estimateTypes(List<EstimateType> estimateTypes) {
            this.estimateTypes = estimateTypes;
            this.changedFields = changedFields.add("EstimateTypes");
            return this;
        }

        public Builder estimateTypesNextLink(String estimateTypesNextLink) {
            this.estimateTypesNextLink = estimateTypesNextLink;
            this.changedFields = changedFields.add("EstimateTypes");
            return this;
        }

        public EstimatesDetailCondition build() {
            EstimatesDetailCondition _x = new EstimatesDetailCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesDetailCondition";
            _x.reportDateRangeType = reportDateRangeType;
            _x.daysAgo = daysAgo;
            _x.fiscalYearFrom = fiscalYearFrom;
            _x.quarterFrom = quarterFrom;
            _x.semiAnnualFrom = semiAnnualFrom;
            _x.fiscalYearTo = fiscalYearTo;
            _x.quarterTo = quarterTo;
            _x.semiAnnualTo = semiAnnualTo;
            _x.reportCompanyType = reportCompanyType;
            _x.estimateTypes = estimateTypes;
            _x.estimateTypesNextLink = estimateTypesNextLink;
            return _x;
        }
    }

    private EstimatesDetailCondition _copy() {
        EstimatesDetailCondition _x = new EstimatesDetailCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportDateRangeType = reportDateRangeType;
        _x.daysAgo = daysAgo;
        _x.fiscalYearFrom = fiscalYearFrom;
        _x.quarterFrom = quarterFrom;
        _x.semiAnnualFrom = semiAnnualFrom;
        _x.fiscalYearTo = fiscalYearTo;
        _x.quarterTo = quarterTo;
        _x.semiAnnualTo = semiAnnualTo;
        _x.reportCompanyType = reportCompanyType;
        _x.estimateTypes = estimateTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EstimatesDetailCondition[");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("FiscalYearFrom=");
        b.append(this.fiscalYearFrom);
        b.append(", ");
        b.append("QuarterFrom=");
        b.append(this.quarterFrom);
        b.append(", ");
        b.append("SemiAnnualFrom=");
        b.append(this.semiAnnualFrom);
        b.append(", ");
        b.append("FiscalYearTo=");
        b.append(this.fiscalYearTo);
        b.append(", ");
        b.append("QuarterTo=");
        b.append(this.quarterTo);
        b.append(", ");
        b.append("SemiAnnualTo=");
        b.append(this.semiAnnualTo);
        b.append(", ");
        b.append("ReportCompanyType=");
        b.append(this.reportCompanyType);
        b.append(", ");
        b.append("EstimateTypes=");
        b.append(this.estimateTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
