package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.FundAllocationTypes;
import thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "FundAllocationTypes"})
public class FundAllocationCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FundAllocationTypes")
    protected List<FundAllocationTypes> fundAllocationTypes;

    @JsonProperty("FundAllocationTypes@nextLink")
    protected String fundAllocationTypesNextLink;

    protected FundAllocationCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.FundAllocationCondition";
    }

    @Property(name="FundAllocationTypes")
    @JsonIgnore
    public CollectionPage<FundAllocationTypes> getFundAllocationTypes() {
        return new CollectionPage<FundAllocationTypes>(contextPath, FundAllocationTypes.class, fundAllocationTypes, Optional.ofNullable(fundAllocationTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<FundAllocationTypes> fundAllocationTypes;
        private String fundAllocationTypesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder fundAllocationTypes(List<FundAllocationTypes> fundAllocationTypes) {
            this.fundAllocationTypes = fundAllocationTypes;
            this.changedFields = changedFields.add("FundAllocationTypes");
            return this;
        }

        public Builder fundAllocationTypesNextLink(String fundAllocationTypesNextLink) {
            this.fundAllocationTypesNextLink = fundAllocationTypesNextLink;
            this.changedFields = changedFields.add("FundAllocationTypes");
            return this;
        }

        public FundAllocationCondition build() {
            FundAllocationCondition _x = new FundAllocationCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.FundAllocationCondition";
            _x.fundAllocationTypes = fundAllocationTypes;
            _x.fundAllocationTypesNextLink = fundAllocationTypesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FundAllocationCondition[");
        b.append("FundAllocationTypes=");
        b.append(this.fundAllocationTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
