package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "StartDate", 
    "EndDate", 
    "ReportDateRangeType", 
    "QueryStartDate", 
    "QueryEndDate", 
    "DaysAgo", 
    "RelativeStartDaysAgo", 
    "RelativeEndDaysAgo"})
public class HistoricalReferenceCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("StartDate")
    protected OffsetDateTime startDate;

    @JsonProperty("EndDate")
    protected OffsetDateTime endDate;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("RelativeStartDaysAgo")
    protected Integer relativeStartDaysAgo;

    @JsonProperty("RelativeEndDaysAgo")
    protected Integer relativeEndDaysAgo;

    protected HistoricalReferenceCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition";
    }

    @Property(name="StartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public HistoricalReferenceCondition withStartDate(OffsetDateTime startDate) {
        HistoricalReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="EndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public HistoricalReferenceCondition withEndDate(OffsetDateTime endDate) {
        HistoricalReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public HistoricalReferenceCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        HistoricalReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public HistoricalReferenceCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        HistoricalReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public HistoricalReferenceCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        HistoricalReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public HistoricalReferenceCondition withDaysAgo(Integer daysAgo) {
        HistoricalReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="RelativeStartDaysAgo")
    @JsonIgnore
    public Optional<Integer> getRelativeStartDaysAgo() {
        return Optional.ofNullable(relativeStartDaysAgo);
    }

    public HistoricalReferenceCondition withRelativeStartDaysAgo(Integer relativeStartDaysAgo) {
        HistoricalReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition");
        _x.relativeStartDaysAgo = relativeStartDaysAgo;
        return _x;
    }

    @Property(name="RelativeEndDaysAgo")
    @JsonIgnore
    public Optional<Integer> getRelativeEndDaysAgo() {
        return Optional.ofNullable(relativeEndDaysAgo);
    }

    public HistoricalReferenceCondition withRelativeEndDaysAgo(Integer relativeEndDaysAgo) {
        HistoricalReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition");
        _x.relativeEndDaysAgo = relativeEndDaysAgo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime startDate;
        private OffsetDateTime endDate;
        private ReportDateRangeType reportDateRangeType;
        private OffsetDateTime queryStartDate;
        private OffsetDateTime queryEndDate;
        private Integer daysAgo;
        private Integer relativeStartDaysAgo;
        private Integer relativeEndDaysAgo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder startDate(OffsetDateTime startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("StartDate");
            return this;
        }

        public Builder endDate(OffsetDateTime endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("EndDate");
            return this;
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder relativeStartDaysAgo(Integer relativeStartDaysAgo) {
            this.relativeStartDaysAgo = relativeStartDaysAgo;
            this.changedFields = changedFields.add("RelativeStartDaysAgo");
            return this;
        }

        public Builder relativeEndDaysAgo(Integer relativeEndDaysAgo) {
            this.relativeEndDaysAgo = relativeEndDaysAgo;
            this.changedFields = changedFields.add("RelativeEndDaysAgo");
            return this;
        }

        public HistoricalReferenceCondition build() {
            HistoricalReferenceCondition _x = new HistoricalReferenceCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.HistoricalReferenceCondition";
            _x.startDate = startDate;
            _x.endDate = endDate;
            _x.reportDateRangeType = reportDateRangeType;
            _x.queryStartDate = queryStartDate;
            _x.queryEndDate = queryEndDate;
            _x.daysAgo = daysAgo;
            _x.relativeStartDaysAgo = relativeStartDaysAgo;
            _x.relativeEndDaysAgo = relativeEndDaysAgo;
            return _x;
        }
    }

    private HistoricalReferenceCondition _copy() {
        HistoricalReferenceCondition _x = new HistoricalReferenceCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.startDate = startDate;
        _x.endDate = endDate;
        _x.reportDateRangeType = reportDateRangeType;
        _x.queryStartDate = queryStartDate;
        _x.queryEndDate = queryEndDate;
        _x.daysAgo = daysAgo;
        _x.relativeStartDaysAgo = relativeStartDaysAgo;
        _x.relativeEndDaysAgo = relativeEndDaysAgo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HistoricalReferenceCondition[");
        b.append("StartDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("EndDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("RelativeStartDaysAgo=");
        b.append(this.relativeStartDaysAgo);
        b.append(", ");
        b.append("RelativeEndDaysAgo=");
        b.append(this.relativeEndDaysAgo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
