package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.NewsAnalyticsNoveltyType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.NewsAnalyticsPrevailingSentimentType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.NewsAnalyticsSourceType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.NewsFilterOperatorType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.NewsItemsSourceType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "NewsCommoditiesCodes", 
    "ReportDateRange", 
    "QueryStartDate", 
    "QueryEndDate", 
    "DaysAgo", 
    "HoursAgo", 
    "MinutesAgo", 
    "NewsAnalyticsRelevanceOperator", 
    "NewsRelevanceValue", 
    "NewsAnalyticsPrevailingSentiment", 
    "NewsAnalyticsNovelty", 
    "NewsFilterNoveltyOperator", 
    "NewsNoveltyValue", 
    "NewsTopicsCodes", 
    "IncludeImbalace", 
    "NewsAnalyticsSource", 
    "NewsItemsSource", 
    "NewsAttributionsCodes"})
public class NewsAnalyticsCommoditiesCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("NewsCommoditiesCodes")
    protected List<String> newsCommoditiesCodes;

    @JsonProperty("NewsCommoditiesCodes@nextLink")
    protected String newsCommoditiesCodesNextLink;

    @JsonProperty("ReportDateRange")
    protected ReportDateRangeType reportDateRange;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("HoursAgo")
    protected Integer hoursAgo;

    @JsonProperty("MinutesAgo")
    protected Integer minutesAgo;

    @JsonProperty("NewsAnalyticsRelevanceOperator")
    protected NewsFilterOperatorType newsAnalyticsRelevanceOperator;

    @JsonProperty("NewsRelevanceValue")
    protected Double newsRelevanceValue;

    @JsonProperty("NewsAnalyticsPrevailingSentiment")
    protected NewsAnalyticsPrevailingSentimentType newsAnalyticsPrevailingSentiment;

    @JsonProperty("NewsAnalyticsNovelty")
    protected NewsAnalyticsNoveltyType newsAnalyticsNovelty;

    @JsonProperty("NewsFilterNoveltyOperator")
    protected NewsFilterOperatorType newsFilterNoveltyOperator;

    @JsonProperty("NewsNoveltyValue")
    protected Integer newsNoveltyValue;

    @JsonProperty("NewsTopicsCodes")
    protected List<String> newsTopicsCodes;

    @JsonProperty("NewsTopicsCodes@nextLink")
    protected String newsTopicsCodesNextLink;

    @JsonProperty("IncludeImbalace")
    protected Boolean includeImbalace;

    @JsonProperty("NewsAnalyticsSource")
    protected NewsAnalyticsSourceType newsAnalyticsSource;

    @JsonProperty("NewsItemsSource")
    protected NewsItemsSourceType newsItemsSource;

    @JsonProperty("NewsAttributionsCodes")
    protected List<String> newsAttributionsCodes;

    @JsonProperty("NewsAttributionsCodes@nextLink")
    protected String newsAttributionsCodesNextLink;

    protected NewsAnalyticsCommoditiesCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition";
    }

    @Property(name="NewsCommoditiesCodes")
    @JsonIgnore
    public CollectionPage<String> getNewsCommoditiesCodes() {
        return new CollectionPage<String>(contextPath, String.class, newsCommoditiesCodes, Optional.ofNullable(newsCommoditiesCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="ReportDateRange")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRange() {
        return Optional.ofNullable(reportDateRange);
    }

    public NewsAnalyticsCommoditiesCondition withReportDateRange(ReportDateRangeType reportDateRange) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.reportDateRange = reportDateRange;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public NewsAnalyticsCommoditiesCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public NewsAnalyticsCommoditiesCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public NewsAnalyticsCommoditiesCondition withDaysAgo(Integer daysAgo) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="HoursAgo")
    @JsonIgnore
    public Optional<Integer> getHoursAgo() {
        return Optional.ofNullable(hoursAgo);
    }

    public NewsAnalyticsCommoditiesCondition withHoursAgo(Integer hoursAgo) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.hoursAgo = hoursAgo;
        return _x;
    }

    @Property(name="MinutesAgo")
    @JsonIgnore
    public Optional<Integer> getMinutesAgo() {
        return Optional.ofNullable(minutesAgo);
    }

    public NewsAnalyticsCommoditiesCondition withMinutesAgo(Integer minutesAgo) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.minutesAgo = minutesAgo;
        return _x;
    }

    @Property(name="NewsAnalyticsRelevanceOperator")
    @JsonIgnore
    public Optional<NewsFilterOperatorType> getNewsAnalyticsRelevanceOperator() {
        return Optional.ofNullable(newsAnalyticsRelevanceOperator);
    }

    public NewsAnalyticsCommoditiesCondition withNewsAnalyticsRelevanceOperator(NewsFilterOperatorType newsAnalyticsRelevanceOperator) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.newsAnalyticsRelevanceOperator = newsAnalyticsRelevanceOperator;
        return _x;
    }

    @Property(name="NewsRelevanceValue")
    @JsonIgnore
    public Optional<Double> getNewsRelevanceValue() {
        return Optional.ofNullable(newsRelevanceValue);
    }

    public NewsAnalyticsCommoditiesCondition withNewsRelevanceValue(Double newsRelevanceValue) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.newsRelevanceValue = newsRelevanceValue;
        return _x;
    }

    @Property(name="NewsAnalyticsPrevailingSentiment")
    @JsonIgnore
    public Optional<NewsAnalyticsPrevailingSentimentType> getNewsAnalyticsPrevailingSentiment() {
        return Optional.ofNullable(newsAnalyticsPrevailingSentiment);
    }

    public NewsAnalyticsCommoditiesCondition withNewsAnalyticsPrevailingSentiment(NewsAnalyticsPrevailingSentimentType newsAnalyticsPrevailingSentiment) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.newsAnalyticsPrevailingSentiment = newsAnalyticsPrevailingSentiment;
        return _x;
    }

    @Property(name="NewsAnalyticsNovelty")
    @JsonIgnore
    public Optional<NewsAnalyticsNoveltyType> getNewsAnalyticsNovelty() {
        return Optional.ofNullable(newsAnalyticsNovelty);
    }

    public NewsAnalyticsCommoditiesCondition withNewsAnalyticsNovelty(NewsAnalyticsNoveltyType newsAnalyticsNovelty) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.newsAnalyticsNovelty = newsAnalyticsNovelty;
        return _x;
    }

    @Property(name="NewsFilterNoveltyOperator")
    @JsonIgnore
    public Optional<NewsFilterOperatorType> getNewsFilterNoveltyOperator() {
        return Optional.ofNullable(newsFilterNoveltyOperator);
    }

    public NewsAnalyticsCommoditiesCondition withNewsFilterNoveltyOperator(NewsFilterOperatorType newsFilterNoveltyOperator) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.newsFilterNoveltyOperator = newsFilterNoveltyOperator;
        return _x;
    }

    @Property(name="NewsNoveltyValue")
    @JsonIgnore
    public Optional<Integer> getNewsNoveltyValue() {
        return Optional.ofNullable(newsNoveltyValue);
    }

    public NewsAnalyticsCommoditiesCondition withNewsNoveltyValue(Integer newsNoveltyValue) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.newsNoveltyValue = newsNoveltyValue;
        return _x;
    }

    @Property(name="NewsTopicsCodes")
    @JsonIgnore
    public CollectionPage<String> getNewsTopicsCodes() {
        return new CollectionPage<String>(contextPath, String.class, newsTopicsCodes, Optional.ofNullable(newsTopicsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="IncludeImbalace")
    @JsonIgnore
    public Optional<Boolean> getIncludeImbalace() {
        return Optional.ofNullable(includeImbalace);
    }

    public NewsAnalyticsCommoditiesCondition withIncludeImbalace(Boolean includeImbalace) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.includeImbalace = includeImbalace;
        return _x;
    }

    @Property(name="NewsAnalyticsSource")
    @JsonIgnore
    public Optional<NewsAnalyticsSourceType> getNewsAnalyticsSource() {
        return Optional.ofNullable(newsAnalyticsSource);
    }

    public NewsAnalyticsCommoditiesCondition withNewsAnalyticsSource(NewsAnalyticsSourceType newsAnalyticsSource) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.newsAnalyticsSource = newsAnalyticsSource;
        return _x;
    }

    @Property(name="NewsItemsSource")
    @JsonIgnore
    public Optional<NewsItemsSourceType> getNewsItemsSource() {
        return Optional.ofNullable(newsItemsSource);
    }

    public NewsAnalyticsCommoditiesCondition withNewsItemsSource(NewsItemsSourceType newsItemsSource) {
        NewsAnalyticsCommoditiesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition");
        _x.newsItemsSource = newsItemsSource;
        return _x;
    }

    @Property(name="NewsAttributionsCodes")
    @JsonIgnore
    public CollectionPage<String> getNewsAttributionsCodes() {
        return new CollectionPage<String>(contextPath, String.class, newsAttributionsCodes, Optional.ofNullable(newsAttributionsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> newsCommoditiesCodes;
        private String newsCommoditiesCodesNextLink;
        private ReportDateRangeType reportDateRange;
        private OffsetDateTime queryStartDate;
        private OffsetDateTime queryEndDate;
        private Integer daysAgo;
        private Integer hoursAgo;
        private Integer minutesAgo;
        private NewsFilterOperatorType newsAnalyticsRelevanceOperator;
        private Double newsRelevanceValue;
        private NewsAnalyticsPrevailingSentimentType newsAnalyticsPrevailingSentiment;
        private NewsAnalyticsNoveltyType newsAnalyticsNovelty;
        private NewsFilterOperatorType newsFilterNoveltyOperator;
        private Integer newsNoveltyValue;
        private List<String> newsTopicsCodes;
        private String newsTopicsCodesNextLink;
        private Boolean includeImbalace;
        private NewsAnalyticsSourceType newsAnalyticsSource;
        private NewsItemsSourceType newsItemsSource;
        private List<String> newsAttributionsCodes;
        private String newsAttributionsCodesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder newsCommoditiesCodes(List<String> newsCommoditiesCodes) {
            this.newsCommoditiesCodes = newsCommoditiesCodes;
            this.changedFields = changedFields.add("NewsCommoditiesCodes");
            return this;
        }

        public Builder newsCommoditiesCodesNextLink(String newsCommoditiesCodesNextLink) {
            this.newsCommoditiesCodesNextLink = newsCommoditiesCodesNextLink;
            this.changedFields = changedFields.add("NewsCommoditiesCodes");
            return this;
        }

        public Builder reportDateRange(ReportDateRangeType reportDateRange) {
            this.reportDateRange = reportDateRange;
            this.changedFields = changedFields.add("ReportDateRange");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder hoursAgo(Integer hoursAgo) {
            this.hoursAgo = hoursAgo;
            this.changedFields = changedFields.add("HoursAgo");
            return this;
        }

        public Builder minutesAgo(Integer minutesAgo) {
            this.minutesAgo = minutesAgo;
            this.changedFields = changedFields.add("MinutesAgo");
            return this;
        }

        public Builder newsAnalyticsRelevanceOperator(NewsFilterOperatorType newsAnalyticsRelevanceOperator) {
            this.newsAnalyticsRelevanceOperator = newsAnalyticsRelevanceOperator;
            this.changedFields = changedFields.add("NewsAnalyticsRelevanceOperator");
            return this;
        }

        public Builder newsRelevanceValue(Double newsRelevanceValue) {
            this.newsRelevanceValue = newsRelevanceValue;
            this.changedFields = changedFields.add("NewsRelevanceValue");
            return this;
        }

        public Builder newsAnalyticsPrevailingSentiment(NewsAnalyticsPrevailingSentimentType newsAnalyticsPrevailingSentiment) {
            this.newsAnalyticsPrevailingSentiment = newsAnalyticsPrevailingSentiment;
            this.changedFields = changedFields.add("NewsAnalyticsPrevailingSentiment");
            return this;
        }

        public Builder newsAnalyticsNovelty(NewsAnalyticsNoveltyType newsAnalyticsNovelty) {
            this.newsAnalyticsNovelty = newsAnalyticsNovelty;
            this.changedFields = changedFields.add("NewsAnalyticsNovelty");
            return this;
        }

        public Builder newsFilterNoveltyOperator(NewsFilterOperatorType newsFilterNoveltyOperator) {
            this.newsFilterNoveltyOperator = newsFilterNoveltyOperator;
            this.changedFields = changedFields.add("NewsFilterNoveltyOperator");
            return this;
        }

        public Builder newsNoveltyValue(Integer newsNoveltyValue) {
            this.newsNoveltyValue = newsNoveltyValue;
            this.changedFields = changedFields.add("NewsNoveltyValue");
            return this;
        }

        public Builder newsTopicsCodes(List<String> newsTopicsCodes) {
            this.newsTopicsCodes = newsTopicsCodes;
            this.changedFields = changedFields.add("NewsTopicsCodes");
            return this;
        }

        public Builder newsTopicsCodesNextLink(String newsTopicsCodesNextLink) {
            this.newsTopicsCodesNextLink = newsTopicsCodesNextLink;
            this.changedFields = changedFields.add("NewsTopicsCodes");
            return this;
        }

        public Builder includeImbalace(Boolean includeImbalace) {
            this.includeImbalace = includeImbalace;
            this.changedFields = changedFields.add("IncludeImbalace");
            return this;
        }

        public Builder newsAnalyticsSource(NewsAnalyticsSourceType newsAnalyticsSource) {
            this.newsAnalyticsSource = newsAnalyticsSource;
            this.changedFields = changedFields.add("NewsAnalyticsSource");
            return this;
        }

        public Builder newsItemsSource(NewsItemsSourceType newsItemsSource) {
            this.newsItemsSource = newsItemsSource;
            this.changedFields = changedFields.add("NewsItemsSource");
            return this;
        }

        public Builder newsAttributionsCodes(List<String> newsAttributionsCodes) {
            this.newsAttributionsCodes = newsAttributionsCodes;
            this.changedFields = changedFields.add("NewsAttributionsCodes");
            return this;
        }

        public Builder newsAttributionsCodesNextLink(String newsAttributionsCodesNextLink) {
            this.newsAttributionsCodesNextLink = newsAttributionsCodesNextLink;
            this.changedFields = changedFields.add("NewsAttributionsCodes");
            return this;
        }

        public NewsAnalyticsCommoditiesCondition build() {
            NewsAnalyticsCommoditiesCondition _x = new NewsAnalyticsCommoditiesCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsAnalyticsCommoditiesCondition";
            _x.newsCommoditiesCodes = newsCommoditiesCodes;
            _x.newsCommoditiesCodesNextLink = newsCommoditiesCodesNextLink;
            _x.reportDateRange = reportDateRange;
            _x.queryStartDate = queryStartDate;
            _x.queryEndDate = queryEndDate;
            _x.daysAgo = daysAgo;
            _x.hoursAgo = hoursAgo;
            _x.minutesAgo = minutesAgo;
            _x.newsAnalyticsRelevanceOperator = newsAnalyticsRelevanceOperator;
            _x.newsRelevanceValue = newsRelevanceValue;
            _x.newsAnalyticsPrevailingSentiment = newsAnalyticsPrevailingSentiment;
            _x.newsAnalyticsNovelty = newsAnalyticsNovelty;
            _x.newsFilterNoveltyOperator = newsFilterNoveltyOperator;
            _x.newsNoveltyValue = newsNoveltyValue;
            _x.newsTopicsCodes = newsTopicsCodes;
            _x.newsTopicsCodesNextLink = newsTopicsCodesNextLink;
            _x.includeImbalace = includeImbalace;
            _x.newsAnalyticsSource = newsAnalyticsSource;
            _x.newsItemsSource = newsItemsSource;
            _x.newsAttributionsCodes = newsAttributionsCodes;
            _x.newsAttributionsCodesNextLink = newsAttributionsCodesNextLink;
            return _x;
        }
    }

    private NewsAnalyticsCommoditiesCondition _copy() {
        NewsAnalyticsCommoditiesCondition _x = new NewsAnalyticsCommoditiesCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.newsCommoditiesCodes = newsCommoditiesCodes;
        _x.reportDateRange = reportDateRange;
        _x.queryStartDate = queryStartDate;
        _x.queryEndDate = queryEndDate;
        _x.daysAgo = daysAgo;
        _x.hoursAgo = hoursAgo;
        _x.minutesAgo = minutesAgo;
        _x.newsAnalyticsRelevanceOperator = newsAnalyticsRelevanceOperator;
        _x.newsRelevanceValue = newsRelevanceValue;
        _x.newsAnalyticsPrevailingSentiment = newsAnalyticsPrevailingSentiment;
        _x.newsAnalyticsNovelty = newsAnalyticsNovelty;
        _x.newsFilterNoveltyOperator = newsFilterNoveltyOperator;
        _x.newsNoveltyValue = newsNoveltyValue;
        _x.newsTopicsCodes = newsTopicsCodes;
        _x.includeImbalace = includeImbalace;
        _x.newsAnalyticsSource = newsAnalyticsSource;
        _x.newsItemsSource = newsItemsSource;
        _x.newsAttributionsCodes = newsAttributionsCodes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NewsAnalyticsCommoditiesCondition[");
        b.append("NewsCommoditiesCodes=");
        b.append(this.newsCommoditiesCodes);
        b.append(", ");
        b.append("ReportDateRange=");
        b.append(this.reportDateRange);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("HoursAgo=");
        b.append(this.hoursAgo);
        b.append(", ");
        b.append("MinutesAgo=");
        b.append(this.minutesAgo);
        b.append(", ");
        b.append("NewsAnalyticsRelevanceOperator=");
        b.append(this.newsAnalyticsRelevanceOperator);
        b.append(", ");
        b.append("NewsRelevanceValue=");
        b.append(this.newsRelevanceValue);
        b.append(", ");
        b.append("NewsAnalyticsPrevailingSentiment=");
        b.append(this.newsAnalyticsPrevailingSentiment);
        b.append(", ");
        b.append("NewsAnalyticsNovelty=");
        b.append(this.newsAnalyticsNovelty);
        b.append(", ");
        b.append("NewsFilterNoveltyOperator=");
        b.append(this.newsFilterNoveltyOperator);
        b.append(", ");
        b.append("NewsNoveltyValue=");
        b.append(this.newsNoveltyValue);
        b.append(", ");
        b.append("NewsTopicsCodes=");
        b.append(this.newsTopicsCodes);
        b.append(", ");
        b.append("IncludeImbalace=");
        b.append(this.includeImbalace);
        b.append(", ");
        b.append("NewsAnalyticsSource=");
        b.append(this.newsAnalyticsSource);
        b.append(", ");
        b.append("NewsItemsSource=");
        b.append(this.newsItemsSource);
        b.append(", ");
        b.append("NewsAttributionsCodes=");
        b.append(this.newsAttributionsCodes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
