package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.NewsItemsLanguageType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.NewsItemsSourceType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ReportDateRangeType", 
    "QueryStartDate", 
    "QueryEndDate", 
    "DaysAgo", 
    "HoursAgo", 
    "MinutesAgo", 
    "NewsTopicsCodes", 
    "NewsItemsLanguage", 
    "NewsLanguagesCodes", 
    "NewsItemsSource", 
    "NewsAttributionsCodes"})
public class NewsItemsCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("HoursAgo")
    protected Integer hoursAgo;

    @JsonProperty("MinutesAgo")
    protected Integer minutesAgo;

    @JsonProperty("NewsTopicsCodes")
    protected List<String> newsTopicsCodes;

    @JsonProperty("NewsTopicsCodes@nextLink")
    protected String newsTopicsCodesNextLink;

    @JsonProperty("NewsItemsLanguage")
    protected NewsItemsLanguageType newsItemsLanguage;

    @JsonProperty("NewsLanguagesCodes")
    protected List<String> newsLanguagesCodes;

    @JsonProperty("NewsLanguagesCodes@nextLink")
    protected String newsLanguagesCodesNextLink;

    @JsonProperty("NewsItemsSource")
    protected NewsItemsSourceType newsItemsSource;

    @JsonProperty("NewsAttributionsCodes")
    protected List<String> newsAttributionsCodes;

    @JsonProperty("NewsAttributionsCodes@nextLink")
    protected String newsAttributionsCodesNextLink;

    protected NewsItemsCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition";
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public NewsItemsCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        NewsItemsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public NewsItemsCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        NewsItemsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public NewsItemsCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        NewsItemsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public NewsItemsCondition withDaysAgo(Integer daysAgo) {
        NewsItemsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="HoursAgo")
    @JsonIgnore
    public Optional<Integer> getHoursAgo() {
        return Optional.ofNullable(hoursAgo);
    }

    public NewsItemsCondition withHoursAgo(Integer hoursAgo) {
        NewsItemsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition");
        _x.hoursAgo = hoursAgo;
        return _x;
    }

    @Property(name="MinutesAgo")
    @JsonIgnore
    public Optional<Integer> getMinutesAgo() {
        return Optional.ofNullable(minutesAgo);
    }

    public NewsItemsCondition withMinutesAgo(Integer minutesAgo) {
        NewsItemsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition");
        _x.minutesAgo = minutesAgo;
        return _x;
    }

    @Property(name="NewsTopicsCodes")
    @JsonIgnore
    public CollectionPage<String> getNewsTopicsCodes() {
        return new CollectionPage<String>(contextPath, String.class, newsTopicsCodes, Optional.ofNullable(newsTopicsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="NewsItemsLanguage")
    @JsonIgnore
    public Optional<NewsItemsLanguageType> getNewsItemsLanguage() {
        return Optional.ofNullable(newsItemsLanguage);
    }

    public NewsItemsCondition withNewsItemsLanguage(NewsItemsLanguageType newsItemsLanguage) {
        NewsItemsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition");
        _x.newsItemsLanguage = newsItemsLanguage;
        return _x;
    }

    @Property(name="NewsLanguagesCodes")
    @JsonIgnore
    public CollectionPage<String> getNewsLanguagesCodes() {
        return new CollectionPage<String>(contextPath, String.class, newsLanguagesCodes, Optional.ofNullable(newsLanguagesCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="NewsItemsSource")
    @JsonIgnore
    public Optional<NewsItemsSourceType> getNewsItemsSource() {
        return Optional.ofNullable(newsItemsSource);
    }

    public NewsItemsCondition withNewsItemsSource(NewsItemsSourceType newsItemsSource) {
        NewsItemsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition");
        _x.newsItemsSource = newsItemsSource;
        return _x;
    }

    @Property(name="NewsAttributionsCodes")
    @JsonIgnore
    public CollectionPage<String> getNewsAttributionsCodes() {
        return new CollectionPage<String>(contextPath, String.class, newsAttributionsCodes, Optional.ofNullable(newsAttributionsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ReportDateRangeType reportDateRangeType;
        private OffsetDateTime queryStartDate;
        private OffsetDateTime queryEndDate;
        private Integer daysAgo;
        private Integer hoursAgo;
        private Integer minutesAgo;
        private List<String> newsTopicsCodes;
        private String newsTopicsCodesNextLink;
        private NewsItemsLanguageType newsItemsLanguage;
        private List<String> newsLanguagesCodes;
        private String newsLanguagesCodesNextLink;
        private NewsItemsSourceType newsItemsSource;
        private List<String> newsAttributionsCodes;
        private String newsAttributionsCodesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder hoursAgo(Integer hoursAgo) {
            this.hoursAgo = hoursAgo;
            this.changedFields = changedFields.add("HoursAgo");
            return this;
        }

        public Builder minutesAgo(Integer minutesAgo) {
            this.minutesAgo = minutesAgo;
            this.changedFields = changedFields.add("MinutesAgo");
            return this;
        }

        public Builder newsTopicsCodes(List<String> newsTopicsCodes) {
            this.newsTopicsCodes = newsTopicsCodes;
            this.changedFields = changedFields.add("NewsTopicsCodes");
            return this;
        }

        public Builder newsTopicsCodesNextLink(String newsTopicsCodesNextLink) {
            this.newsTopicsCodesNextLink = newsTopicsCodesNextLink;
            this.changedFields = changedFields.add("NewsTopicsCodes");
            return this;
        }

        public Builder newsItemsLanguage(NewsItemsLanguageType newsItemsLanguage) {
            this.newsItemsLanguage = newsItemsLanguage;
            this.changedFields = changedFields.add("NewsItemsLanguage");
            return this;
        }

        public Builder newsLanguagesCodes(List<String> newsLanguagesCodes) {
            this.newsLanguagesCodes = newsLanguagesCodes;
            this.changedFields = changedFields.add("NewsLanguagesCodes");
            return this;
        }

        public Builder newsLanguagesCodesNextLink(String newsLanguagesCodesNextLink) {
            this.newsLanguagesCodesNextLink = newsLanguagesCodesNextLink;
            this.changedFields = changedFields.add("NewsLanguagesCodes");
            return this;
        }

        public Builder newsItemsSource(NewsItemsSourceType newsItemsSource) {
            this.newsItemsSource = newsItemsSource;
            this.changedFields = changedFields.add("NewsItemsSource");
            return this;
        }

        public Builder newsAttributionsCodes(List<String> newsAttributionsCodes) {
            this.newsAttributionsCodes = newsAttributionsCodes;
            this.changedFields = changedFields.add("NewsAttributionsCodes");
            return this;
        }

        public Builder newsAttributionsCodesNextLink(String newsAttributionsCodesNextLink) {
            this.newsAttributionsCodesNextLink = newsAttributionsCodesNextLink;
            this.changedFields = changedFields.add("NewsAttributionsCodes");
            return this;
        }

        public NewsItemsCondition build() {
            NewsItemsCondition _x = new NewsItemsCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.NewsItemsCondition";
            _x.reportDateRangeType = reportDateRangeType;
            _x.queryStartDate = queryStartDate;
            _x.queryEndDate = queryEndDate;
            _x.daysAgo = daysAgo;
            _x.hoursAgo = hoursAgo;
            _x.minutesAgo = minutesAgo;
            _x.newsTopicsCodes = newsTopicsCodes;
            _x.newsTopicsCodesNextLink = newsTopicsCodesNextLink;
            _x.newsItemsLanguage = newsItemsLanguage;
            _x.newsLanguagesCodes = newsLanguagesCodes;
            _x.newsLanguagesCodesNextLink = newsLanguagesCodesNextLink;
            _x.newsItemsSource = newsItemsSource;
            _x.newsAttributionsCodes = newsAttributionsCodes;
            _x.newsAttributionsCodesNextLink = newsAttributionsCodesNextLink;
            return _x;
        }
    }

    private NewsItemsCondition _copy() {
        NewsItemsCondition _x = new NewsItemsCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportDateRangeType = reportDateRangeType;
        _x.queryStartDate = queryStartDate;
        _x.queryEndDate = queryEndDate;
        _x.daysAgo = daysAgo;
        _x.hoursAgo = hoursAgo;
        _x.minutesAgo = minutesAgo;
        _x.newsTopicsCodes = newsTopicsCodes;
        _x.newsItemsLanguage = newsItemsLanguage;
        _x.newsLanguagesCodes = newsLanguagesCodes;
        _x.newsItemsSource = newsItemsSource;
        _x.newsAttributionsCodes = newsAttributionsCodes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NewsItemsCondition[");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("HoursAgo=");
        b.append(this.hoursAgo);
        b.append(", ");
        b.append("MinutesAgo=");
        b.append(this.minutesAgo);
        b.append(", ");
        b.append("NewsTopicsCodes=");
        b.append(this.newsTopicsCodes);
        b.append(", ");
        b.append("NewsItemsLanguage=");
        b.append(this.newsItemsLanguage);
        b.append(", ");
        b.append("NewsLanguagesCodes=");
        b.append(this.newsLanguagesCodes);
        b.append(", ");
        b.append("NewsItemsSource=");
        b.append(this.newsItemsSource);
        b.append(", ");
        b.append("NewsAttributionsCodes=");
        b.append(this.newsAttributionsCodes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
