package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "IntradayFixedIncomePremiumEndOfDay", 
    "IncludeIntradayPricing", 
    "ScalableCurrency"})
public class PremiumEndOfDayPricingCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("IntradayFixedIncomePremiumEndOfDay")
    protected Boolean intradayFixedIncomePremiumEndOfDay;

    @JsonProperty("IncludeIntradayPricing")
    protected Boolean includeIntradayPricing;

    @JsonProperty("ScalableCurrency")
    protected Boolean scalableCurrency;

    protected PremiumEndOfDayPricingCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumEndOfDayPricingCondition";
    }

    @Property(name="IntradayFixedIncomePremiumEndOfDay")
    @JsonIgnore
    public Optional<Boolean> getIntradayFixedIncomePremiumEndOfDay() {
        return Optional.ofNullable(intradayFixedIncomePremiumEndOfDay);
    }

    public PremiumEndOfDayPricingCondition withIntradayFixedIncomePremiumEndOfDay(Boolean intradayFixedIncomePremiumEndOfDay) {
        PremiumEndOfDayPricingCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumEndOfDayPricingCondition");
        _x.intradayFixedIncomePremiumEndOfDay = intradayFixedIncomePremiumEndOfDay;
        return _x;
    }

    @Property(name="IncludeIntradayPricing")
    @JsonIgnore
    public Optional<Boolean> getIncludeIntradayPricing() {
        return Optional.ofNullable(includeIntradayPricing);
    }

    public PremiumEndOfDayPricingCondition withIncludeIntradayPricing(Boolean includeIntradayPricing) {
        PremiumEndOfDayPricingCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumEndOfDayPricingCondition");
        _x.includeIntradayPricing = includeIntradayPricing;
        return _x;
    }

    @Property(name="ScalableCurrency")
    @JsonIgnore
    public Optional<Boolean> getScalableCurrency() {
        return Optional.ofNullable(scalableCurrency);
    }

    public PremiumEndOfDayPricingCondition withScalableCurrency(Boolean scalableCurrency) {
        PremiumEndOfDayPricingCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumEndOfDayPricingCondition");
        _x.scalableCurrency = scalableCurrency;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean intradayFixedIncomePremiumEndOfDay;
        private Boolean includeIntradayPricing;
        private Boolean scalableCurrency;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder intradayFixedIncomePremiumEndOfDay(Boolean intradayFixedIncomePremiumEndOfDay) {
            this.intradayFixedIncomePremiumEndOfDay = intradayFixedIncomePremiumEndOfDay;
            this.changedFields = changedFields.add("IntradayFixedIncomePremiumEndOfDay");
            return this;
        }

        public Builder includeIntradayPricing(Boolean includeIntradayPricing) {
            this.includeIntradayPricing = includeIntradayPricing;
            this.changedFields = changedFields.add("IncludeIntradayPricing");
            return this;
        }

        public Builder scalableCurrency(Boolean scalableCurrency) {
            this.scalableCurrency = scalableCurrency;
            this.changedFields = changedFields.add("ScalableCurrency");
            return this;
        }

        public PremiumEndOfDayPricingCondition build() {
            PremiumEndOfDayPricingCondition _x = new PremiumEndOfDayPricingCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumEndOfDayPricingCondition";
            _x.intradayFixedIncomePremiumEndOfDay = intradayFixedIncomePremiumEndOfDay;
            _x.includeIntradayPricing = includeIntradayPricing;
            _x.scalableCurrency = scalableCurrency;
            return _x;
        }
    }

    private PremiumEndOfDayPricingCondition _copy() {
        PremiumEndOfDayPricingCondition _x = new PremiumEndOfDayPricingCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.intradayFixedIncomePremiumEndOfDay = intradayFixedIncomePremiumEndOfDay;
        _x.includeIntradayPricing = includeIntradayPricing;
        _x.scalableCurrency = scalableCurrency;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PremiumEndOfDayPricingCondition[");
        b.append("IntradayFixedIncomePremiumEndOfDay=");
        b.append(this.intradayFixedIncomePremiumEndOfDay);
        b.append(", ");
        b.append("IncludeIntradayPricing=");
        b.append(this.includeIntradayPricing);
        b.append(", ");
        b.append("ScalableCurrency=");
        b.append(this.scalableCurrency);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
