package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ApplyFIGSPricing"})
public class PremiumPricingUS4PMEstUdtCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ApplyFIGSPricing")
    protected Boolean applyFIGSPricing;

    protected PremiumPricingUS4PMEstUdtCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumPricingUS4PMEstUdtCondition";
    }

    @Property(name="ApplyFIGSPricing")
    @JsonIgnore
    public Optional<Boolean> getApplyFIGSPricing() {
        return Optional.ofNullable(applyFIGSPricing);
    }

    public PremiumPricingUS4PMEstUdtCondition withApplyFIGSPricing(Boolean applyFIGSPricing) {
        PremiumPricingUS4PMEstUdtCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumPricingUS4PMEstUdtCondition");
        _x.applyFIGSPricing = applyFIGSPricing;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean applyFIGSPricing;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder applyFIGSPricing(Boolean applyFIGSPricing) {
            this.applyFIGSPricing = applyFIGSPricing;
            this.changedFields = changedFields.add("ApplyFIGSPricing");
            return this;
        }

        public PremiumPricingUS4PMEstUdtCondition build() {
            PremiumPricingUS4PMEstUdtCondition _x = new PremiumPricingUS4PMEstUdtCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PremiumPricingUS4PMEstUdtCondition";
            _x.applyFIGSPricing = applyFIGSPricing;
            return _x;
        }
    }

    private PremiumPricingUS4PMEstUdtCondition _copy() {
        PremiumPricingUS4PMEstUdtCondition _x = new PremiumPricingUS4PMEstUdtCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.applyFIGSPricing = applyFIGSPricing;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PremiumPricingUS4PMEstUdtCondition[");
        b.append("ApplyFIGSPricing=");
        b.append(this.applyFIGSPricing);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
