package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "QueryStartDate", 
    "QueryEndDate", 
    "AdjustedPrices"})
public class PriceHistoryCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("AdjustedPrices")
    protected Boolean adjustedPrices;

    protected PriceHistoryCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PriceHistoryCondition";
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public PriceHistoryCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        PriceHistoryCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PriceHistoryCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public PriceHistoryCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        PriceHistoryCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PriceHistoryCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="AdjustedPrices")
    @JsonIgnore
    public Optional<Boolean> getAdjustedPrices() {
        return Optional.ofNullable(adjustedPrices);
    }

    public PriceHistoryCondition withAdjustedPrices(Boolean adjustedPrices) {
        PriceHistoryCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PriceHistoryCondition");
        _x.adjustedPrices = adjustedPrices;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime queryStartDate;
        private OffsetDateTime queryEndDate;
        private Boolean adjustedPrices;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder adjustedPrices(Boolean adjustedPrices) {
            this.adjustedPrices = adjustedPrices;
            this.changedFields = changedFields.add("AdjustedPrices");
            return this;
        }

        public PriceHistoryCondition build() {
            PriceHistoryCondition _x = new PriceHistoryCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.PriceHistoryCondition";
            _x.queryStartDate = queryStartDate;
            _x.queryEndDate = queryEndDate;
            _x.adjustedPrices = adjustedPrices;
            return _x;
        }
    }

    private PriceHistoryCondition _copy() {
        PriceHistoryCondition _x = new PriceHistoryCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.queryStartDate = queryStartDate;
        _x.queryEndDate = queryEndDate;
        _x.adjustedPrices = adjustedPrices;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PriceHistoryCondition[");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("AdjustedPrices=");
        b.append(this.adjustedPrices);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
