package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "IsIssue", 
    "IsIssuer"})
public class RatingLevel implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("IsIssue")
    protected Boolean isIssue;

    @JsonProperty("IsIssuer")
    protected Boolean isIssuer;

    protected RatingLevel() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingLevel";
    }

    @Property(name="IsIssue")
    @JsonIgnore
    public Optional<Boolean> getIsIssue() {
        return Optional.ofNullable(isIssue);
    }

    public RatingLevel withIsIssue(Boolean isIssue) {
        RatingLevel _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingLevel");
        _x.isIssue = isIssue;
        return _x;
    }

    @Property(name="IsIssuer")
    @JsonIgnore
    public Optional<Boolean> getIsIssuer() {
        return Optional.ofNullable(isIssuer);
    }

    public RatingLevel withIsIssuer(Boolean isIssuer) {
        RatingLevel _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingLevel");
        _x.isIssuer = isIssuer;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isIssue;
        private Boolean isIssuer;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder isIssue(Boolean isIssue) {
            this.isIssue = isIssue;
            this.changedFields = changedFields.add("IsIssue");
            return this;
        }

        public Builder isIssuer(Boolean isIssuer) {
            this.isIssuer = isIssuer;
            this.changedFields = changedFields.add("IsIssuer");
            return this;
        }

        public RatingLevel build() {
            RatingLevel _x = new RatingLevel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingLevel";
            _x.isIssue = isIssue;
            _x.isIssuer = isIssuer;
            return _x;
        }
    }

    private RatingLevel _copy() {
        RatingLevel _x = new RatingLevel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.isIssue = isIssue;
        _x.isIssuer = isIssuer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RatingLevel[");
        b.append("IsIssue=");
        b.append(this.isIssue);
        b.append(", ");
        b.append("IsIssuer=");
        b.append(this.isIssuer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
