package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.complex.RatingLevel;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "RatingLevel", 
    "ReportDateRangeType", 
    "DaysAgo", 
    "QueryStartDate", 
    "QueryEndDate", 
    "IncludeInstrumentsWithNoRatings", 
    "RatingSourcesCodes"})
public class RatingsCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RatingLevel")
    protected RatingLevel ratingLevel;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("IncludeInstrumentsWithNoRatings")
    protected Boolean includeInstrumentsWithNoRatings;

    @JsonProperty("RatingSourcesCodes")
    protected List<String> ratingSourcesCodes;

    @JsonProperty("RatingSourcesCodes@nextLink")
    protected String ratingSourcesCodesNextLink;

    protected RatingsCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition";
    }

    @Property(name="RatingLevel")
    @JsonIgnore
    public Optional<RatingLevel> getRatingLevel() {
        return Optional.ofNullable(ratingLevel);
    }

    public RatingsCondition withRatingLevel(RatingLevel ratingLevel) {
        RatingsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition");
        _x.ratingLevel = ratingLevel;
        return _x;
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public RatingsCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        RatingsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public RatingsCondition withDaysAgo(Integer daysAgo) {
        RatingsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public RatingsCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        RatingsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public RatingsCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        RatingsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="IncludeInstrumentsWithNoRatings")
    @JsonIgnore
    public Optional<Boolean> getIncludeInstrumentsWithNoRatings() {
        return Optional.ofNullable(includeInstrumentsWithNoRatings);
    }

    public RatingsCondition withIncludeInstrumentsWithNoRatings(Boolean includeInstrumentsWithNoRatings) {
        RatingsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition");
        _x.includeInstrumentsWithNoRatings = includeInstrumentsWithNoRatings;
        return _x;
    }

    @Property(name="RatingSourcesCodes")
    @JsonIgnore
    public CollectionPage<String> getRatingSourcesCodes() {
        return new CollectionPage<String>(contextPath, String.class, ratingSourcesCodes, Optional.ofNullable(ratingSourcesCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RatingLevel ratingLevel;
        private ReportDateRangeType reportDateRangeType;
        private Integer daysAgo;
        private OffsetDateTime queryStartDate;
        private OffsetDateTime queryEndDate;
        private Boolean includeInstrumentsWithNoRatings;
        private List<String> ratingSourcesCodes;
        private String ratingSourcesCodesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ratingLevel(RatingLevel ratingLevel) {
            this.ratingLevel = ratingLevel;
            this.changedFields = changedFields.add("RatingLevel");
            return this;
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder includeInstrumentsWithNoRatings(Boolean includeInstrumentsWithNoRatings) {
            this.includeInstrumentsWithNoRatings = includeInstrumentsWithNoRatings;
            this.changedFields = changedFields.add("IncludeInstrumentsWithNoRatings");
            return this;
        }

        public Builder ratingSourcesCodes(List<String> ratingSourcesCodes) {
            this.ratingSourcesCodes = ratingSourcesCodes;
            this.changedFields = changedFields.add("RatingSourcesCodes");
            return this;
        }

        public Builder ratingSourcesCodesNextLink(String ratingSourcesCodesNextLink) {
            this.ratingSourcesCodesNextLink = ratingSourcesCodesNextLink;
            this.changedFields = changedFields.add("RatingSourcesCodes");
            return this;
        }

        public RatingsCondition build() {
            RatingsCondition _x = new RatingsCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.RatingsCondition";
            _x.ratingLevel = ratingLevel;
            _x.reportDateRangeType = reportDateRangeType;
            _x.daysAgo = daysAgo;
            _x.queryStartDate = queryStartDate;
            _x.queryEndDate = queryEndDate;
            _x.includeInstrumentsWithNoRatings = includeInstrumentsWithNoRatings;
            _x.ratingSourcesCodes = ratingSourcesCodes;
            _x.ratingSourcesCodesNextLink = ratingSourcesCodesNextLink;
            return _x;
        }
    }

    private RatingsCondition _copy() {
        RatingsCondition _x = new RatingsCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ratingLevel = ratingLevel;
        _x.reportDateRangeType = reportDateRangeType;
        _x.daysAgo = daysAgo;
        _x.queryStartDate = queryStartDate;
        _x.queryEndDate = queryEndDate;
        _x.includeInstrumentsWithNoRatings = includeInstrumentsWithNoRatings;
        _x.ratingSourcesCodes = ratingSourcesCodes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RatingsCondition[");
        b.append("RatingLevel=");
        b.append(this.ratingLevel);
        b.append(", ");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("IncludeInstrumentsWithNoRatings=");
        b.append(this.includeInstrumentsWithNoRatings);
        b.append(", ");
        b.append("RatingSourcesCodes=");
        b.append(this.ratingSourcesCodes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
