package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.ContentFieldJustification;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ContentFieldWidthStyle;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportHeaderFieldType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Number", 
    "FieldType", 
    "Justification", 
    "LineNumber", 
    "UserData", 
    "Width", 
    "WidthStyle", 
    "Label", 
    "ShowThousandsSeparator"})
public class ReportHeaderField implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Number")
    protected Integer number;

    @JsonProperty("FieldType")
    protected ReportHeaderFieldType fieldType;

    @JsonProperty("Justification")
    protected ContentFieldJustification justification;

    @JsonProperty("LineNumber")
    protected Integer lineNumber;

    @JsonProperty("UserData")
    protected String userData;

    @JsonProperty("Width")
    protected Integer width;

    @JsonProperty("WidthStyle")
    protected ContentFieldWidthStyle widthStyle;

    @JsonProperty("Label")
    protected String label;

    @JsonProperty("ShowThousandsSeparator")
    protected Boolean showThousandsSeparator;

    protected ReportHeaderField() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField";
    }

    @Property(name="Number")
    @JsonIgnore
    public Optional<Integer> getNumber() {
        return Optional.ofNullable(number);
    }

    public ReportHeaderField withNumber(Integer number) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.number = number;
        return _x;
    }

    @Property(name="FieldType")
    @JsonIgnore
    public Optional<ReportHeaderFieldType> getFieldType() {
        return Optional.ofNullable(fieldType);
    }

    public ReportHeaderField withFieldType(ReportHeaderFieldType fieldType) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.fieldType = fieldType;
        return _x;
    }

    @Property(name="Justification")
    @JsonIgnore
    public Optional<ContentFieldJustification> getJustification() {
        return Optional.ofNullable(justification);
    }

    public ReportHeaderField withJustification(ContentFieldJustification justification) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.justification = justification;
        return _x;
    }

    @Property(name="LineNumber")
    @JsonIgnore
    public Optional<Integer> getLineNumber() {
        return Optional.ofNullable(lineNumber);
    }

    public ReportHeaderField withLineNumber(Integer lineNumber) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.lineNumber = lineNumber;
        return _x;
    }

    @Property(name="UserData")
    @JsonIgnore
    public Optional<String> getUserData() {
        return Optional.ofNullable(userData);
    }

    public ReportHeaderField withUserData(String userData) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.userData = userData;
        return _x;
    }

    @Property(name="Width")
    @JsonIgnore
    public Optional<Integer> getWidth() {
        return Optional.ofNullable(width);
    }

    public ReportHeaderField withWidth(Integer width) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.width = width;
        return _x;
    }

    @Property(name="WidthStyle")
    @JsonIgnore
    public Optional<ContentFieldWidthStyle> getWidthStyle() {
        return Optional.ofNullable(widthStyle);
    }

    public ReportHeaderField withWidthStyle(ContentFieldWidthStyle widthStyle) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.widthStyle = widthStyle;
        return _x;
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    public ReportHeaderField withLabel(String label) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.label = label;
        return _x;
    }

    @Property(name="ShowThousandsSeparator")
    @JsonIgnore
    public Optional<Boolean> getShowThousandsSeparator() {
        return Optional.ofNullable(showThousandsSeparator);
    }

    public ReportHeaderField withShowThousandsSeparator(Boolean showThousandsSeparator) {
        ReportHeaderField _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField");
        _x.showThousandsSeparator = showThousandsSeparator;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer number;
        private ReportHeaderFieldType fieldType;
        private ContentFieldJustification justification;
        private Integer lineNumber;
        private String userData;
        private Integer width;
        private ContentFieldWidthStyle widthStyle;
        private String label;
        private Boolean showThousandsSeparator;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder number(Integer number) {
            this.number = number;
            this.changedFields = changedFields.add("Number");
            return this;
        }

        public Builder fieldType(ReportHeaderFieldType fieldType) {
            this.fieldType = fieldType;
            this.changedFields = changedFields.add("FieldType");
            return this;
        }

        public Builder justification(ContentFieldJustification justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("Justification");
            return this;
        }

        public Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            this.changedFields = changedFields.add("LineNumber");
            return this;
        }

        public Builder userData(String userData) {
            this.userData = userData;
            this.changedFields = changedFields.add("UserData");
            return this;
        }

        public Builder width(Integer width) {
            this.width = width;
            this.changedFields = changedFields.add("Width");
            return this;
        }

        public Builder widthStyle(ContentFieldWidthStyle widthStyle) {
            this.widthStyle = widthStyle;
            this.changedFields = changedFields.add("WidthStyle");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("Label");
            return this;
        }

        public Builder showThousandsSeparator(Boolean showThousandsSeparator) {
            this.showThousandsSeparator = showThousandsSeparator;
            this.changedFields = changedFields.add("ShowThousandsSeparator");
            return this;
        }

        public ReportHeaderField build() {
            ReportHeaderField _x = new ReportHeaderField();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportHeaderField";
            _x.number = number;
            _x.fieldType = fieldType;
            _x.justification = justification;
            _x.lineNumber = lineNumber;
            _x.userData = userData;
            _x.width = width;
            _x.widthStyle = widthStyle;
            _x.label = label;
            _x.showThousandsSeparator = showThousandsSeparator;
            return _x;
        }
    }

    private ReportHeaderField _copy() {
        ReportHeaderField _x = new ReportHeaderField();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.number = number;
        _x.fieldType = fieldType;
        _x.justification = justification;
        _x.lineNumber = lineNumber;
        _x.userData = userData;
        _x.width = width;
        _x.widthStyle = widthStyle;
        _x.label = label;
        _x.showThousandsSeparator = showThousandsSeparator;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReportHeaderField[");
        b.append("Number=");
        b.append(this.number);
        b.append(", ");
        b.append("FieldType=");
        b.append(this.fieldType);
        b.append(", ");
        b.append("Justification=");
        b.append(this.justification);
        b.append(", ");
        b.append("LineNumber=");
        b.append(this.lineNumber);
        b.append(", ");
        b.append("UserData=");
        b.append(this.userData);
        b.append(", ");
        b.append("Width=");
        b.append(this.width);
        b.append(", ");
        b.append("WidthStyle=");
        b.append(this.widthStyle);
        b.append(", ");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("ShowThousandsSeparator=");
        b.append(this.showThousandsSeparator);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
