package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ErrorMessages", 
    "WarningMessages"})
public class ReportTemplatesImportResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ErrorMessages")
    protected List<String> errorMessages;

    @JsonProperty("ErrorMessages@nextLink")
    protected String errorMessagesNextLink;

    @JsonProperty("WarningMessages")
    protected List<String> warningMessages;

    @JsonProperty("WarningMessages@nextLink")
    protected String warningMessagesNextLink;

    protected ReportTemplatesImportResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplatesImportResult";
    }

    @Property(name="ErrorMessages")
    @JsonIgnore
    public CollectionPage<String> getErrorMessages() {
        return new CollectionPage<String>(contextPath, String.class, errorMessages, Optional.ofNullable(errorMessagesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="WarningMessages")
    @JsonIgnore
    public CollectionPage<String> getWarningMessages() {
        return new CollectionPage<String>(contextPath, String.class, warningMessages, Optional.ofNullable(warningMessagesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> errorMessages;
        private String errorMessagesNextLink;
        private List<String> warningMessages;
        private String warningMessagesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder errorMessages(List<String> errorMessages) {
            this.errorMessages = errorMessages;
            this.changedFields = changedFields.add("ErrorMessages");
            return this;
        }

        public Builder errorMessagesNextLink(String errorMessagesNextLink) {
            this.errorMessagesNextLink = errorMessagesNextLink;
            this.changedFields = changedFields.add("ErrorMessages");
            return this;
        }

        public Builder warningMessages(List<String> warningMessages) {
            this.warningMessages = warningMessages;
            this.changedFields = changedFields.add("WarningMessages");
            return this;
        }

        public Builder warningMessagesNextLink(String warningMessagesNextLink) {
            this.warningMessagesNextLink = warningMessagesNextLink;
            this.changedFields = changedFields.add("WarningMessages");
            return this;
        }

        public ReportTemplatesImportResult build() {
            ReportTemplatesImportResult _x = new ReportTemplatesImportResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplatesImportResult";
            _x.errorMessages = errorMessages;
            _x.errorMessagesNextLink = errorMessagesNextLink;
            _x.warningMessages = warningMessages;
            _x.warningMessagesNextLink = warningMessagesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReportTemplatesImportResult[");
        b.append("ErrorMessages=");
        b.append(this.errorMessages);
        b.append(", ");
        b.append("WarningMessages=");
        b.append(this.warningMessages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
