package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.LookbackType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "PriceDate", 
    "LookBackPeriod"})
public class SingleHistoricalPriceCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PriceDate")
    protected OffsetDateTime priceDate;

    @JsonProperty("LookBackPeriod")
    protected LookbackType lookBackPeriod;

    protected SingleHistoricalPriceCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SingleHistoricalPriceCondition";
    }

    @Property(name="PriceDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getPriceDate() {
        return Optional.ofNullable(priceDate);
    }

    public SingleHistoricalPriceCondition withPriceDate(OffsetDateTime priceDate) {
        SingleHistoricalPriceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SingleHistoricalPriceCondition");
        _x.priceDate = priceDate;
        return _x;
    }

    @Property(name="LookBackPeriod")
    @JsonIgnore
    public Optional<LookbackType> getLookBackPeriod() {
        return Optional.ofNullable(lookBackPeriod);
    }

    public SingleHistoricalPriceCondition withLookBackPeriod(LookbackType lookBackPeriod) {
        SingleHistoricalPriceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SingleHistoricalPriceCondition");
        _x.lookBackPeriod = lookBackPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime priceDate;
        private LookbackType lookBackPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder priceDate(OffsetDateTime priceDate) {
            this.priceDate = priceDate;
            this.changedFields = changedFields.add("PriceDate");
            return this;
        }

        public Builder lookBackPeriod(LookbackType lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            this.changedFields = changedFields.add("LookBackPeriod");
            return this;
        }

        public SingleHistoricalPriceCondition build() {
            SingleHistoricalPriceCondition _x = new SingleHistoricalPriceCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SingleHistoricalPriceCondition";
            _x.priceDate = priceDate;
            _x.lookBackPeriod = lookBackPeriod;
            return _x;
        }
    }

    private SingleHistoricalPriceCondition _copy() {
        SingleHistoricalPriceCondition _x = new SingleHistoricalPriceCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.priceDate = priceDate;
        _x.lookBackPeriod = lookBackPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SingleHistoricalPriceCondition[");
        b.append("PriceDate=");
        b.append(this.priceDate);
        b.append(", ");
        b.append("LookBackPeriod=");
        b.append(this.lookBackPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
