package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.LookbackType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "EndDate", 
    "Lookback", 
    "AdjustedPrices"})
public class SinglePriceHistoryCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EndDate")
    protected OffsetDateTime endDate;

    @JsonProperty("Lookback")
    protected LookbackType lookback;

    @JsonProperty("AdjustedPrices")
    protected Boolean adjustedPrices;

    protected SinglePriceHistoryCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SinglePriceHistoryCondition";
    }

    @Property(name="EndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public SinglePriceHistoryCondition withEndDate(OffsetDateTime endDate) {
        SinglePriceHistoryCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SinglePriceHistoryCondition");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="Lookback")
    @JsonIgnore
    public Optional<LookbackType> getLookback() {
        return Optional.ofNullable(lookback);
    }

    public SinglePriceHistoryCondition withLookback(LookbackType lookback) {
        SinglePriceHistoryCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SinglePriceHistoryCondition");
        _x.lookback = lookback;
        return _x;
    }

    @Property(name="AdjustedPrices")
    @JsonIgnore
    public Optional<Boolean> getAdjustedPrices() {
        return Optional.ofNullable(adjustedPrices);
    }

    public SinglePriceHistoryCondition withAdjustedPrices(Boolean adjustedPrices) {
        SinglePriceHistoryCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SinglePriceHistoryCondition");
        _x.adjustedPrices = adjustedPrices;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime endDate;
        private LookbackType lookback;
        private Boolean adjustedPrices;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder endDate(OffsetDateTime endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("EndDate");
            return this;
        }

        public Builder lookback(LookbackType lookback) {
            this.lookback = lookback;
            this.changedFields = changedFields.add("Lookback");
            return this;
        }

        public Builder adjustedPrices(Boolean adjustedPrices) {
            this.adjustedPrices = adjustedPrices;
            this.changedFields = changedFields.add("AdjustedPrices");
            return this;
        }

        public SinglePriceHistoryCondition build() {
            SinglePriceHistoryCondition _x = new SinglePriceHistoryCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SinglePriceHistoryCondition";
            _x.endDate = endDate;
            _x.lookback = lookback;
            _x.adjustedPrices = adjustedPrices;
            return _x;
        }
    }

    private SinglePriceHistoryCondition _copy() {
        SinglePriceHistoryCondition _x = new SinglePriceHistoryCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.endDate = endDate;
        _x.lookback = lookback;
        _x.adjustedPrices = adjustedPrices;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SinglePriceHistoryCondition[");
        b.append("EndDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("Lookback=");
        b.append(this.lookback);
        b.append(", ");
        b.append("AdjustedPrices=");
        b.append(this.adjustedPrices);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
