package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "IdentifierTypes", 
    "ReportDateRangeType", 
    "DaysAgo", 
    "SpecificDate", 
    "AllXRefIdentifierTypes"})
public class SymbolCrossReferenceCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("IdentifierTypes")
    protected List<IdentifierType> identifierTypes;

    @JsonProperty("IdentifierTypes@nextLink")
    protected String identifierTypesNextLink;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("SpecificDate")
    protected OffsetDateTime specificDate;

    @JsonProperty("AllXRefIdentifierTypes")
    protected Boolean allXRefIdentifierTypes;

    protected SymbolCrossReferenceCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SymbolCrossReferenceCondition";
    }

    @Property(name="IdentifierTypes")
    @JsonIgnore
    public CollectionPage<IdentifierType> getIdentifierTypes() {
        return new CollectionPage<IdentifierType>(contextPath, IdentifierType.class, identifierTypes, Optional.ofNullable(identifierTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public SymbolCrossReferenceCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        SymbolCrossReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SymbolCrossReferenceCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public SymbolCrossReferenceCondition withDaysAgo(Integer daysAgo) {
        SymbolCrossReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SymbolCrossReferenceCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="SpecificDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getSpecificDate() {
        return Optional.ofNullable(specificDate);
    }

    public SymbolCrossReferenceCondition withSpecificDate(OffsetDateTime specificDate) {
        SymbolCrossReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SymbolCrossReferenceCondition");
        _x.specificDate = specificDate;
        return _x;
    }

    @Property(name="AllXRefIdentifierTypes")
    @JsonIgnore
    public Optional<Boolean> getAllXRefIdentifierTypes() {
        return Optional.ofNullable(allXRefIdentifierTypes);
    }

    public SymbolCrossReferenceCondition withAllXRefIdentifierTypes(Boolean allXRefIdentifierTypes) {
        SymbolCrossReferenceCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SymbolCrossReferenceCondition");
        _x.allXRefIdentifierTypes = allXRefIdentifierTypes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IdentifierType> identifierTypes;
        private String identifierTypesNextLink;
        private ReportDateRangeType reportDateRangeType;
        private Integer daysAgo;
        private OffsetDateTime specificDate;
        private Boolean allXRefIdentifierTypes;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identifierTypes(List<IdentifierType> identifierTypes) {
            this.identifierTypes = identifierTypes;
            this.changedFields = changedFields.add("IdentifierTypes");
            return this;
        }

        public Builder identifierTypesNextLink(String identifierTypesNextLink) {
            this.identifierTypesNextLink = identifierTypesNextLink;
            this.changedFields = changedFields.add("IdentifierTypes");
            return this;
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder specificDate(OffsetDateTime specificDate) {
            this.specificDate = specificDate;
            this.changedFields = changedFields.add("SpecificDate");
            return this;
        }

        public Builder allXRefIdentifierTypes(Boolean allXRefIdentifierTypes) {
            this.allXRefIdentifierTypes = allXRefIdentifierTypes;
            this.changedFields = changedFields.add("AllXRefIdentifierTypes");
            return this;
        }

        public SymbolCrossReferenceCondition build() {
            SymbolCrossReferenceCondition _x = new SymbolCrossReferenceCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.SymbolCrossReferenceCondition";
            _x.identifierTypes = identifierTypes;
            _x.identifierTypesNextLink = identifierTypesNextLink;
            _x.reportDateRangeType = reportDateRangeType;
            _x.daysAgo = daysAgo;
            _x.specificDate = specificDate;
            _x.allXRefIdentifierTypes = allXRefIdentifierTypes;
            return _x;
        }
    }

    private SymbolCrossReferenceCondition _copy() {
        SymbolCrossReferenceCondition _x = new SymbolCrossReferenceCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identifierTypes = identifierTypes;
        _x.reportDateRangeType = reportDateRangeType;
        _x.daysAgo = daysAgo;
        _x.specificDate = specificDate;
        _x.allXRefIdentifierTypes = allXRefIdentifierTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SymbolCrossReferenceCondition[");
        b.append("IdentifierTypes=");
        b.append(this.identifierTypes);
        b.append(", ");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("SpecificDate=");
        b.append(this.specificDate);
        b.append(", ");
        b.append("AllXRefIdentifierTypes=");
        b.append(this.allXRefIdentifierTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
