package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.FixedIncomeRatingSource;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.IssuerAssetClassType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "IssuerAssetClassType", 
    "ExcludeWarrants", 
    "DaysAgo", 
    "StartDate", 
    "FixedIncomeRatingSources", 
    "UseRelativeAnalytics"})
public class TermsAndConditionsCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("IssuerAssetClassType")
    protected IssuerAssetClassType issuerAssetClassType;

    @JsonProperty("ExcludeWarrants")
    protected Boolean excludeWarrants;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("StartDate")
    protected OffsetDateTime startDate;

    @JsonProperty("FixedIncomeRatingSources")
    protected FixedIncomeRatingSource fixedIncomeRatingSources;

    @JsonProperty("UseRelativeAnalytics")
    protected Boolean useRelativeAnalytics;

    protected TermsAndConditionsCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition";
    }

    @Property(name="IssuerAssetClassType")
    @JsonIgnore
    public Optional<IssuerAssetClassType> getIssuerAssetClassType() {
        return Optional.ofNullable(issuerAssetClassType);
    }

    public TermsAndConditionsCondition withIssuerAssetClassType(IssuerAssetClassType issuerAssetClassType) {
        TermsAndConditionsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition");
        _x.issuerAssetClassType = issuerAssetClassType;
        return _x;
    }

    @Property(name="ExcludeWarrants")
    @JsonIgnore
    public Optional<Boolean> getExcludeWarrants() {
        return Optional.ofNullable(excludeWarrants);
    }

    public TermsAndConditionsCondition withExcludeWarrants(Boolean excludeWarrants) {
        TermsAndConditionsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition");
        _x.excludeWarrants = excludeWarrants;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public TermsAndConditionsCondition withDaysAgo(Integer daysAgo) {
        TermsAndConditionsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="StartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public TermsAndConditionsCondition withStartDate(OffsetDateTime startDate) {
        TermsAndConditionsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="FixedIncomeRatingSources")
    @JsonIgnore
    public Optional<FixedIncomeRatingSource> getFixedIncomeRatingSources() {
        return Optional.ofNullable(fixedIncomeRatingSources);
    }

    public TermsAndConditionsCondition withFixedIncomeRatingSources(FixedIncomeRatingSource fixedIncomeRatingSources) {
        TermsAndConditionsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition");
        _x.fixedIncomeRatingSources = fixedIncomeRatingSources;
        return _x;
    }

    @Property(name="UseRelativeAnalytics")
    @JsonIgnore
    public Optional<Boolean> getUseRelativeAnalytics() {
        return Optional.ofNullable(useRelativeAnalytics);
    }

    public TermsAndConditionsCondition withUseRelativeAnalytics(Boolean useRelativeAnalytics) {
        TermsAndConditionsCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition");
        _x.useRelativeAnalytics = useRelativeAnalytics;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IssuerAssetClassType issuerAssetClassType;
        private Boolean excludeWarrants;
        private Integer daysAgo;
        private OffsetDateTime startDate;
        private FixedIncomeRatingSource fixedIncomeRatingSources;
        private Boolean useRelativeAnalytics;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder issuerAssetClassType(IssuerAssetClassType issuerAssetClassType) {
            this.issuerAssetClassType = issuerAssetClassType;
            this.changedFields = changedFields.add("IssuerAssetClassType");
            return this;
        }

        public Builder excludeWarrants(Boolean excludeWarrants) {
            this.excludeWarrants = excludeWarrants;
            this.changedFields = changedFields.add("ExcludeWarrants");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder startDate(OffsetDateTime startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("StartDate");
            return this;
        }

        public Builder fixedIncomeRatingSources(FixedIncomeRatingSource fixedIncomeRatingSources) {
            this.fixedIncomeRatingSources = fixedIncomeRatingSources;
            this.changedFields = changedFields.add("FixedIncomeRatingSources");
            return this;
        }

        public Builder useRelativeAnalytics(Boolean useRelativeAnalytics) {
            this.useRelativeAnalytics = useRelativeAnalytics;
            this.changedFields = changedFields.add("UseRelativeAnalytics");
            return this;
        }

        public TermsAndConditionsCondition build() {
            TermsAndConditionsCondition _x = new TermsAndConditionsCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TermsAndConditionsCondition";
            _x.issuerAssetClassType = issuerAssetClassType;
            _x.excludeWarrants = excludeWarrants;
            _x.daysAgo = daysAgo;
            _x.startDate = startDate;
            _x.fixedIncomeRatingSources = fixedIncomeRatingSources;
            _x.useRelativeAnalytics = useRelativeAnalytics;
            return _x;
        }
    }

    private TermsAndConditionsCondition _copy() {
        TermsAndConditionsCondition _x = new TermsAndConditionsCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.issuerAssetClassType = issuerAssetClassType;
        _x.excludeWarrants = excludeWarrants;
        _x.daysAgo = daysAgo;
        _x.startDate = startDate;
        _x.fixedIncomeRatingSources = fixedIncomeRatingSources;
        _x.useRelativeAnalytics = useRelativeAnalytics;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TermsAndConditionsCondition[");
        b.append("IssuerAssetClassType=");
        b.append(this.issuerAssetClassType);
        b.append(", ");
        b.append("ExcludeWarrants=");
        b.append(this.excludeWarrants);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("StartDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("FixedIncomeRatingSources=");
        b.append(this.fixedIncomeRatingSources);
        b.append(", ");
        b.append("UseRelativeAnalytics=");
        b.append(this.useRelativeAnalytics);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
