package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.PreviewMode;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistoryExtractByMode;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistoryRawDomain;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistorySort;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistoryTimeOptions;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistoryTimeRangeMode;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "SortBy", 
    "MessageTimeStampIn", 
    "ReportDateRangeType", 
    "TimeRangeMode", 
    "QueryStartDate", 
    "QueryEndDate", 
    "DaysAgo", 
    "RelativeStartDaysAgo", 
    "RelativeEndDaysAgo", 
    "RelativeStartTime", 
    "RelativeEndTime", 
    "DateRangeTimeZone", 
    "DomainCode", 
    "Preview", 
    "ExtractBy", 
    "Fids", 
    "DisplaySourceRIC"})
public class TickHistoryRawCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("SortBy")
    protected TickHistorySort sortBy;

    @JsonProperty("MessageTimeStampIn")
    protected TickHistoryTimeOptions messageTimeStampIn;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("TimeRangeMode")
    protected TickHistoryTimeRangeMode timeRangeMode;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("RelativeStartDaysAgo")
    protected Integer relativeStartDaysAgo;

    @JsonProperty("RelativeEndDaysAgo")
    protected Integer relativeEndDaysAgo;

    @JsonProperty("RelativeStartTime")
    protected String relativeStartTime;

    @JsonProperty("RelativeEndTime")
    protected String relativeEndTime;

    @JsonProperty("DateRangeTimeZone")
    protected String dateRangeTimeZone;

    @JsonProperty("DomainCode")
    protected TickHistoryRawDomain domainCode;

    @JsonProperty("Preview")
    protected PreviewMode preview;

    @JsonProperty("ExtractBy")
    protected TickHistoryExtractByMode extractBy;

    @JsonProperty("Fids")
    protected String fids;

    @JsonProperty("DisplaySourceRIC")
    protected Boolean displaySourceRIC;

    protected TickHistoryRawCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition";
    }

    @Property(name="SortBy")
    @JsonIgnore
    public Optional<TickHistorySort> getSortBy() {
        return Optional.ofNullable(sortBy);
    }

    public TickHistoryRawCondition withSortBy(TickHistorySort sortBy) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.sortBy = sortBy;
        return _x;
    }

    @Property(name="MessageTimeStampIn")
    @JsonIgnore
    public Optional<TickHistoryTimeOptions> getMessageTimeStampIn() {
        return Optional.ofNullable(messageTimeStampIn);
    }

    public TickHistoryRawCondition withMessageTimeStampIn(TickHistoryTimeOptions messageTimeStampIn) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.messageTimeStampIn = messageTimeStampIn;
        return _x;
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public TickHistoryRawCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="TimeRangeMode")
    @JsonIgnore
    public Optional<TickHistoryTimeRangeMode> getTimeRangeMode() {
        return Optional.ofNullable(timeRangeMode);
    }

    public TickHistoryRawCondition withTimeRangeMode(TickHistoryTimeRangeMode timeRangeMode) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.timeRangeMode = timeRangeMode;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public TickHistoryRawCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public TickHistoryRawCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public TickHistoryRawCondition withDaysAgo(Integer daysAgo) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="RelativeStartDaysAgo")
    @JsonIgnore
    public Optional<Integer> getRelativeStartDaysAgo() {
        return Optional.ofNullable(relativeStartDaysAgo);
    }

    public TickHistoryRawCondition withRelativeStartDaysAgo(Integer relativeStartDaysAgo) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.relativeStartDaysAgo = relativeStartDaysAgo;
        return _x;
    }

    @Property(name="RelativeEndDaysAgo")
    @JsonIgnore
    public Optional<Integer> getRelativeEndDaysAgo() {
        return Optional.ofNullable(relativeEndDaysAgo);
    }

    public TickHistoryRawCondition withRelativeEndDaysAgo(Integer relativeEndDaysAgo) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.relativeEndDaysAgo = relativeEndDaysAgo;
        return _x;
    }

    @Property(name="RelativeStartTime")
    @JsonIgnore
    public Optional<String> getRelativeStartTime() {
        return Optional.ofNullable(relativeStartTime);
    }

    public TickHistoryRawCondition withRelativeStartTime(String relativeStartTime) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.relativeStartTime = relativeStartTime;
        return _x;
    }

    @Property(name="RelativeEndTime")
    @JsonIgnore
    public Optional<String> getRelativeEndTime() {
        return Optional.ofNullable(relativeEndTime);
    }

    public TickHistoryRawCondition withRelativeEndTime(String relativeEndTime) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.relativeEndTime = relativeEndTime;
        return _x;
    }

    @Property(name="DateRangeTimeZone")
    @JsonIgnore
    public Optional<String> getDateRangeTimeZone() {
        return Optional.ofNullable(dateRangeTimeZone);
    }

    public TickHistoryRawCondition withDateRangeTimeZone(String dateRangeTimeZone) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.dateRangeTimeZone = dateRangeTimeZone;
        return _x;
    }

    @Property(name="DomainCode")
    @JsonIgnore
    public Optional<TickHistoryRawDomain> getDomainCode() {
        return Optional.ofNullable(domainCode);
    }

    public TickHistoryRawCondition withDomainCode(TickHistoryRawDomain domainCode) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.domainCode = domainCode;
        return _x;
    }

    @Property(name="Preview")
    @JsonIgnore
    public Optional<PreviewMode> getPreview() {
        return Optional.ofNullable(preview);
    }

    public TickHistoryRawCondition withPreview(PreviewMode preview) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.preview = preview;
        return _x;
    }

    @Property(name="ExtractBy")
    @JsonIgnore
    public Optional<TickHistoryExtractByMode> getExtractBy() {
        return Optional.ofNullable(extractBy);
    }

    public TickHistoryRawCondition withExtractBy(TickHistoryExtractByMode extractBy) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.extractBy = extractBy;
        return _x;
    }

    @Property(name="Fids")
    @JsonIgnore
    public Optional<String> getFids() {
        return Optional.ofNullable(fids);
    }

    public TickHistoryRawCondition withFids(String fids) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.fids = fids;
        return _x;
    }

    @Property(name="DisplaySourceRIC")
    @JsonIgnore
    public Optional<Boolean> getDisplaySourceRIC() {
        return Optional.ofNullable(displaySourceRIC);
    }

    public TickHistoryRawCondition withDisplaySourceRIC(Boolean displaySourceRIC) {
        TickHistoryRawCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition");
        _x.displaySourceRIC = displaySourceRIC;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TickHistorySort sortBy;
        private TickHistoryTimeOptions messageTimeStampIn;
        private ReportDateRangeType reportDateRangeType;
        private TickHistoryTimeRangeMode timeRangeMode;
        private OffsetDateTime queryStartDate;
        private OffsetDateTime queryEndDate;
        private Integer daysAgo;
        private Integer relativeStartDaysAgo;
        private Integer relativeEndDaysAgo;
        private String relativeStartTime;
        private String relativeEndTime;
        private String dateRangeTimeZone;
        private TickHistoryRawDomain domainCode;
        private PreviewMode preview;
        private TickHistoryExtractByMode extractBy;
        private String fids;
        private Boolean displaySourceRIC;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder sortBy(TickHistorySort sortBy) {
            this.sortBy = sortBy;
            this.changedFields = changedFields.add("SortBy");
            return this;
        }

        public Builder messageTimeStampIn(TickHistoryTimeOptions messageTimeStampIn) {
            this.messageTimeStampIn = messageTimeStampIn;
            this.changedFields = changedFields.add("MessageTimeStampIn");
            return this;
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder timeRangeMode(TickHistoryTimeRangeMode timeRangeMode) {
            this.timeRangeMode = timeRangeMode;
            this.changedFields = changedFields.add("TimeRangeMode");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder relativeStartDaysAgo(Integer relativeStartDaysAgo) {
            this.relativeStartDaysAgo = relativeStartDaysAgo;
            this.changedFields = changedFields.add("RelativeStartDaysAgo");
            return this;
        }

        public Builder relativeEndDaysAgo(Integer relativeEndDaysAgo) {
            this.relativeEndDaysAgo = relativeEndDaysAgo;
            this.changedFields = changedFields.add("RelativeEndDaysAgo");
            return this;
        }

        public Builder relativeStartTime(String relativeStartTime) {
            this.relativeStartTime = relativeStartTime;
            this.changedFields = changedFields.add("RelativeStartTime");
            return this;
        }

        public Builder relativeEndTime(String relativeEndTime) {
            this.relativeEndTime = relativeEndTime;
            this.changedFields = changedFields.add("RelativeEndTime");
            return this;
        }

        public Builder dateRangeTimeZone(String dateRangeTimeZone) {
            this.dateRangeTimeZone = dateRangeTimeZone;
            this.changedFields = changedFields.add("DateRangeTimeZone");
            return this;
        }

        public Builder domainCode(TickHistoryRawDomain domainCode) {
            this.domainCode = domainCode;
            this.changedFields = changedFields.add("DomainCode");
            return this;
        }

        public Builder preview(PreviewMode preview) {
            this.preview = preview;
            this.changedFields = changedFields.add("Preview");
            return this;
        }

        public Builder extractBy(TickHistoryExtractByMode extractBy) {
            this.extractBy = extractBy;
            this.changedFields = changedFields.add("ExtractBy");
            return this;
        }

        public Builder fids(String fids) {
            this.fids = fids;
            this.changedFields = changedFields.add("Fids");
            return this;
        }

        public Builder displaySourceRIC(Boolean displaySourceRIC) {
            this.displaySourceRIC = displaySourceRIC;
            this.changedFields = changedFields.add("DisplaySourceRIC");
            return this;
        }

        public TickHistoryRawCondition build() {
            TickHistoryRawCondition _x = new TickHistoryRawCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryRawCondition";
            _x.sortBy = sortBy;
            _x.messageTimeStampIn = messageTimeStampIn;
            _x.reportDateRangeType = reportDateRangeType;
            _x.timeRangeMode = timeRangeMode;
            _x.queryStartDate = queryStartDate;
            _x.queryEndDate = queryEndDate;
            _x.daysAgo = daysAgo;
            _x.relativeStartDaysAgo = relativeStartDaysAgo;
            _x.relativeEndDaysAgo = relativeEndDaysAgo;
            _x.relativeStartTime = relativeStartTime;
            _x.relativeEndTime = relativeEndTime;
            _x.dateRangeTimeZone = dateRangeTimeZone;
            _x.domainCode = domainCode;
            _x.preview = preview;
            _x.extractBy = extractBy;
            _x.fids = fids;
            _x.displaySourceRIC = displaySourceRIC;
            return _x;
        }
    }

    private TickHistoryRawCondition _copy() {
        TickHistoryRawCondition _x = new TickHistoryRawCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.sortBy = sortBy;
        _x.messageTimeStampIn = messageTimeStampIn;
        _x.reportDateRangeType = reportDateRangeType;
        _x.timeRangeMode = timeRangeMode;
        _x.queryStartDate = queryStartDate;
        _x.queryEndDate = queryEndDate;
        _x.daysAgo = daysAgo;
        _x.relativeStartDaysAgo = relativeStartDaysAgo;
        _x.relativeEndDaysAgo = relativeEndDaysAgo;
        _x.relativeStartTime = relativeStartTime;
        _x.relativeEndTime = relativeEndTime;
        _x.dateRangeTimeZone = dateRangeTimeZone;
        _x.domainCode = domainCode;
        _x.preview = preview;
        _x.extractBy = extractBy;
        _x.fids = fids;
        _x.displaySourceRIC = displaySourceRIC;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TickHistoryRawCondition[");
        b.append("SortBy=");
        b.append(this.sortBy);
        b.append(", ");
        b.append("MessageTimeStampIn=");
        b.append(this.messageTimeStampIn);
        b.append(", ");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("TimeRangeMode=");
        b.append(this.timeRangeMode);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("RelativeStartDaysAgo=");
        b.append(this.relativeStartDaysAgo);
        b.append(", ");
        b.append("RelativeEndDaysAgo=");
        b.append(this.relativeEndDaysAgo);
        b.append(", ");
        b.append("RelativeStartTime=");
        b.append(this.relativeStartTime);
        b.append(", ");
        b.append("RelativeEndTime=");
        b.append(this.relativeEndTime);
        b.append(", ");
        b.append("DateRangeTimeZone=");
        b.append(this.dateRangeTimeZone);
        b.append(", ");
        b.append("DomainCode=");
        b.append(this.domainCode);
        b.append(", ");
        b.append("Preview=");
        b.append(this.preview);
        b.append(", ");
        b.append("ExtractBy=");
        b.append(this.extractBy);
        b.append(", ");
        b.append("Fids=");
        b.append(this.fids);
        b.append(", ");
        b.append("DisplaySourceRIC=");
        b.append(this.displaySourceRIC);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
