package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.enums.PreviewMode;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDateRangeType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistoryExtractByMode;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistorySort;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistoryTimeOptions;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.TickHistoryTimeRangeMode;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "SortBy", 
    "MessageTimeStampIn", 
    "TimeRangeMode", 
    "ApplyCorrectionsAndCancellations", 
    "ReportDateRangeType", 
    "QueryStartDate", 
    "QueryEndDate", 
    "DaysAgo", 
    "RelativeStartDaysAgo", 
    "RelativeEndDaysAgo", 
    "RelativeStartTime", 
    "RelativeEndTime", 
    "DateRangeTimeZone", 
    "Preview", 
    "ExtractBy", 
    "DisplaySourceRIC"})
public class TickHistoryTimeAndSalesCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("SortBy")
    protected TickHistorySort sortBy;

    @JsonProperty("MessageTimeStampIn")
    protected TickHistoryTimeOptions messageTimeStampIn;

    @JsonProperty("TimeRangeMode")
    protected TickHistoryTimeRangeMode timeRangeMode;

    @JsonProperty("ApplyCorrectionsAndCancellations")
    protected Boolean applyCorrectionsAndCancellations;

    @JsonProperty("ReportDateRangeType")
    protected ReportDateRangeType reportDateRangeType;

    @JsonProperty("QueryStartDate")
    protected OffsetDateTime queryStartDate;

    @JsonProperty("QueryEndDate")
    protected OffsetDateTime queryEndDate;

    @JsonProperty("DaysAgo")
    protected Integer daysAgo;

    @JsonProperty("RelativeStartDaysAgo")
    protected Integer relativeStartDaysAgo;

    @JsonProperty("RelativeEndDaysAgo")
    protected Integer relativeEndDaysAgo;

    @JsonProperty("RelativeStartTime")
    protected String relativeStartTime;

    @JsonProperty("RelativeEndTime")
    protected String relativeEndTime;

    @JsonProperty("DateRangeTimeZone")
    protected String dateRangeTimeZone;

    @JsonProperty("Preview")
    protected PreviewMode preview;

    @JsonProperty("ExtractBy")
    protected TickHistoryExtractByMode extractBy;

    @JsonProperty("DisplaySourceRIC")
    protected Boolean displaySourceRIC;

    protected TickHistoryTimeAndSalesCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition";
    }

    @Property(name="SortBy")
    @JsonIgnore
    public Optional<TickHistorySort> getSortBy() {
        return Optional.ofNullable(sortBy);
    }

    public TickHistoryTimeAndSalesCondition withSortBy(TickHistorySort sortBy) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.sortBy = sortBy;
        return _x;
    }

    @Property(name="MessageTimeStampIn")
    @JsonIgnore
    public Optional<TickHistoryTimeOptions> getMessageTimeStampIn() {
        return Optional.ofNullable(messageTimeStampIn);
    }

    public TickHistoryTimeAndSalesCondition withMessageTimeStampIn(TickHistoryTimeOptions messageTimeStampIn) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.messageTimeStampIn = messageTimeStampIn;
        return _x;
    }

    @Property(name="TimeRangeMode")
    @JsonIgnore
    public Optional<TickHistoryTimeRangeMode> getTimeRangeMode() {
        return Optional.ofNullable(timeRangeMode);
    }

    public TickHistoryTimeAndSalesCondition withTimeRangeMode(TickHistoryTimeRangeMode timeRangeMode) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.timeRangeMode = timeRangeMode;
        return _x;
    }

    @Property(name="ApplyCorrectionsAndCancellations")
    @JsonIgnore
    public Optional<Boolean> getApplyCorrectionsAndCancellations() {
        return Optional.ofNullable(applyCorrectionsAndCancellations);
    }

    public TickHistoryTimeAndSalesCondition withApplyCorrectionsAndCancellations(Boolean applyCorrectionsAndCancellations) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.applyCorrectionsAndCancellations = applyCorrectionsAndCancellations;
        return _x;
    }

    @Property(name="ReportDateRangeType")
    @JsonIgnore
    public Optional<ReportDateRangeType> getReportDateRangeType() {
        return Optional.ofNullable(reportDateRangeType);
    }

    public TickHistoryTimeAndSalesCondition withReportDateRangeType(ReportDateRangeType reportDateRangeType) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.reportDateRangeType = reportDateRangeType;
        return _x;
    }

    @Property(name="QueryStartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryStartDate() {
        return Optional.ofNullable(queryStartDate);
    }

    public TickHistoryTimeAndSalesCondition withQueryStartDate(OffsetDateTime queryStartDate) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.queryStartDate = queryStartDate;
        return _x;
    }

    @Property(name="QueryEndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getQueryEndDate() {
        return Optional.ofNullable(queryEndDate);
    }

    public TickHistoryTimeAndSalesCondition withQueryEndDate(OffsetDateTime queryEndDate) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.queryEndDate = queryEndDate;
        return _x;
    }

    @Property(name="DaysAgo")
    @JsonIgnore
    public Optional<Integer> getDaysAgo() {
        return Optional.ofNullable(daysAgo);
    }

    public TickHistoryTimeAndSalesCondition withDaysAgo(Integer daysAgo) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.daysAgo = daysAgo;
        return _x;
    }

    @Property(name="RelativeStartDaysAgo")
    @JsonIgnore
    public Optional<Integer> getRelativeStartDaysAgo() {
        return Optional.ofNullable(relativeStartDaysAgo);
    }

    public TickHistoryTimeAndSalesCondition withRelativeStartDaysAgo(Integer relativeStartDaysAgo) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.relativeStartDaysAgo = relativeStartDaysAgo;
        return _x;
    }

    @Property(name="RelativeEndDaysAgo")
    @JsonIgnore
    public Optional<Integer> getRelativeEndDaysAgo() {
        return Optional.ofNullable(relativeEndDaysAgo);
    }

    public TickHistoryTimeAndSalesCondition withRelativeEndDaysAgo(Integer relativeEndDaysAgo) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.relativeEndDaysAgo = relativeEndDaysAgo;
        return _x;
    }

    @Property(name="RelativeStartTime")
    @JsonIgnore
    public Optional<String> getRelativeStartTime() {
        return Optional.ofNullable(relativeStartTime);
    }

    public TickHistoryTimeAndSalesCondition withRelativeStartTime(String relativeStartTime) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.relativeStartTime = relativeStartTime;
        return _x;
    }

    @Property(name="RelativeEndTime")
    @JsonIgnore
    public Optional<String> getRelativeEndTime() {
        return Optional.ofNullable(relativeEndTime);
    }

    public TickHistoryTimeAndSalesCondition withRelativeEndTime(String relativeEndTime) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.relativeEndTime = relativeEndTime;
        return _x;
    }

    @Property(name="DateRangeTimeZone")
    @JsonIgnore
    public Optional<String> getDateRangeTimeZone() {
        return Optional.ofNullable(dateRangeTimeZone);
    }

    public TickHistoryTimeAndSalesCondition withDateRangeTimeZone(String dateRangeTimeZone) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.dateRangeTimeZone = dateRangeTimeZone;
        return _x;
    }

    @Property(name="Preview")
    @JsonIgnore
    public Optional<PreviewMode> getPreview() {
        return Optional.ofNullable(preview);
    }

    public TickHistoryTimeAndSalesCondition withPreview(PreviewMode preview) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.preview = preview;
        return _x;
    }

    @Property(name="ExtractBy")
    @JsonIgnore
    public Optional<TickHistoryExtractByMode> getExtractBy() {
        return Optional.ofNullable(extractBy);
    }

    public TickHistoryTimeAndSalesCondition withExtractBy(TickHistoryExtractByMode extractBy) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.extractBy = extractBy;
        return _x;
    }

    @Property(name="DisplaySourceRIC")
    @JsonIgnore
    public Optional<Boolean> getDisplaySourceRIC() {
        return Optional.ofNullable(displaySourceRIC);
    }

    public TickHistoryTimeAndSalesCondition withDisplaySourceRIC(Boolean displaySourceRIC) {
        TickHistoryTimeAndSalesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition");
        _x.displaySourceRIC = displaySourceRIC;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TickHistorySort sortBy;
        private TickHistoryTimeOptions messageTimeStampIn;
        private TickHistoryTimeRangeMode timeRangeMode;
        private Boolean applyCorrectionsAndCancellations;
        private ReportDateRangeType reportDateRangeType;
        private OffsetDateTime queryStartDate;
        private OffsetDateTime queryEndDate;
        private Integer daysAgo;
        private Integer relativeStartDaysAgo;
        private Integer relativeEndDaysAgo;
        private String relativeStartTime;
        private String relativeEndTime;
        private String dateRangeTimeZone;
        private PreviewMode preview;
        private TickHistoryExtractByMode extractBy;
        private Boolean displaySourceRIC;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder sortBy(TickHistorySort sortBy) {
            this.sortBy = sortBy;
            this.changedFields = changedFields.add("SortBy");
            return this;
        }

        public Builder messageTimeStampIn(TickHistoryTimeOptions messageTimeStampIn) {
            this.messageTimeStampIn = messageTimeStampIn;
            this.changedFields = changedFields.add("MessageTimeStampIn");
            return this;
        }

        public Builder timeRangeMode(TickHistoryTimeRangeMode timeRangeMode) {
            this.timeRangeMode = timeRangeMode;
            this.changedFields = changedFields.add("TimeRangeMode");
            return this;
        }

        public Builder applyCorrectionsAndCancellations(Boolean applyCorrectionsAndCancellations) {
            this.applyCorrectionsAndCancellations = applyCorrectionsAndCancellations;
            this.changedFields = changedFields.add("ApplyCorrectionsAndCancellations");
            return this;
        }

        public Builder reportDateRangeType(ReportDateRangeType reportDateRangeType) {
            this.reportDateRangeType = reportDateRangeType;
            this.changedFields = changedFields.add("ReportDateRangeType");
            return this;
        }

        public Builder queryStartDate(OffsetDateTime queryStartDate) {
            this.queryStartDate = queryStartDate;
            this.changedFields = changedFields.add("QueryStartDate");
            return this;
        }

        public Builder queryEndDate(OffsetDateTime queryEndDate) {
            this.queryEndDate = queryEndDate;
            this.changedFields = changedFields.add("QueryEndDate");
            return this;
        }

        public Builder daysAgo(Integer daysAgo) {
            this.daysAgo = daysAgo;
            this.changedFields = changedFields.add("DaysAgo");
            return this;
        }

        public Builder relativeStartDaysAgo(Integer relativeStartDaysAgo) {
            this.relativeStartDaysAgo = relativeStartDaysAgo;
            this.changedFields = changedFields.add("RelativeStartDaysAgo");
            return this;
        }

        public Builder relativeEndDaysAgo(Integer relativeEndDaysAgo) {
            this.relativeEndDaysAgo = relativeEndDaysAgo;
            this.changedFields = changedFields.add("RelativeEndDaysAgo");
            return this;
        }

        public Builder relativeStartTime(String relativeStartTime) {
            this.relativeStartTime = relativeStartTime;
            this.changedFields = changedFields.add("RelativeStartTime");
            return this;
        }

        public Builder relativeEndTime(String relativeEndTime) {
            this.relativeEndTime = relativeEndTime;
            this.changedFields = changedFields.add("RelativeEndTime");
            return this;
        }

        public Builder dateRangeTimeZone(String dateRangeTimeZone) {
            this.dateRangeTimeZone = dateRangeTimeZone;
            this.changedFields = changedFields.add("DateRangeTimeZone");
            return this;
        }

        public Builder preview(PreviewMode preview) {
            this.preview = preview;
            this.changedFields = changedFields.add("Preview");
            return this;
        }

        public Builder extractBy(TickHistoryExtractByMode extractBy) {
            this.extractBy = extractBy;
            this.changedFields = changedFields.add("ExtractBy");
            return this;
        }

        public Builder displaySourceRIC(Boolean displaySourceRIC) {
            this.displaySourceRIC = displaySourceRIC;
            this.changedFields = changedFields.add("DisplaySourceRIC");
            return this;
        }

        public TickHistoryTimeAndSalesCondition build() {
            TickHistoryTimeAndSalesCondition _x = new TickHistoryTimeAndSalesCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TickHistoryTimeAndSalesCondition";
            _x.sortBy = sortBy;
            _x.messageTimeStampIn = messageTimeStampIn;
            _x.timeRangeMode = timeRangeMode;
            _x.applyCorrectionsAndCancellations = applyCorrectionsAndCancellations;
            _x.reportDateRangeType = reportDateRangeType;
            _x.queryStartDate = queryStartDate;
            _x.queryEndDate = queryEndDate;
            _x.daysAgo = daysAgo;
            _x.relativeStartDaysAgo = relativeStartDaysAgo;
            _x.relativeEndDaysAgo = relativeEndDaysAgo;
            _x.relativeStartTime = relativeStartTime;
            _x.relativeEndTime = relativeEndTime;
            _x.dateRangeTimeZone = dateRangeTimeZone;
            _x.preview = preview;
            _x.extractBy = extractBy;
            _x.displaySourceRIC = displaySourceRIC;
            return _x;
        }
    }

    private TickHistoryTimeAndSalesCondition _copy() {
        TickHistoryTimeAndSalesCondition _x = new TickHistoryTimeAndSalesCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.sortBy = sortBy;
        _x.messageTimeStampIn = messageTimeStampIn;
        _x.timeRangeMode = timeRangeMode;
        _x.applyCorrectionsAndCancellations = applyCorrectionsAndCancellations;
        _x.reportDateRangeType = reportDateRangeType;
        _x.queryStartDate = queryStartDate;
        _x.queryEndDate = queryEndDate;
        _x.daysAgo = daysAgo;
        _x.relativeStartDaysAgo = relativeStartDaysAgo;
        _x.relativeEndDaysAgo = relativeEndDaysAgo;
        _x.relativeStartTime = relativeStartTime;
        _x.relativeEndTime = relativeEndTime;
        _x.dateRangeTimeZone = dateRangeTimeZone;
        _x.preview = preview;
        _x.extractBy = extractBy;
        _x.displaySourceRIC = displaySourceRIC;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TickHistoryTimeAndSalesCondition[");
        b.append("SortBy=");
        b.append(this.sortBy);
        b.append(", ");
        b.append("MessageTimeStampIn=");
        b.append(this.messageTimeStampIn);
        b.append(", ");
        b.append("TimeRangeMode=");
        b.append(this.timeRangeMode);
        b.append(", ");
        b.append("ApplyCorrectionsAndCancellations=");
        b.append(this.applyCorrectionsAndCancellations);
        b.append(", ");
        b.append("ReportDateRangeType=");
        b.append(this.reportDateRangeType);
        b.append(", ");
        b.append("QueryStartDate=");
        b.append(this.queryStartDate);
        b.append(", ");
        b.append("QueryEndDate=");
        b.append(this.queryEndDate);
        b.append(", ");
        b.append("DaysAgo=");
        b.append(this.daysAgo);
        b.append(", ");
        b.append("RelativeStartDaysAgo=");
        b.append(this.relativeStartDaysAgo);
        b.append(", ");
        b.append("RelativeEndDaysAgo=");
        b.append(this.relativeEndDaysAgo);
        b.append(", ");
        b.append("RelativeStartTime=");
        b.append(this.relativeStartTime);
        b.append(", ");
        b.append("RelativeEndTime=");
        b.append(this.relativeEndTime);
        b.append(", ");
        b.append("DateRangeTimeZone=");
        b.append(this.dateRangeTimeZone);
        b.append(", ");
        b.append("Preview=");
        b.append(this.preview);
        b.append(", ");
        b.append("ExtractBy=");
        b.append(this.extractBy);
        b.append(", ");
        b.append("DisplaySourceRIC=");
        b.append(this.displaySourceRIC);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
