package thomsonreuters.dss.api.extractions.reporttemplates.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "LastPriceOnly", 
    "StartDate", 
    "EndDate", 
    "LookBackPeriod"})
public class TimeSeriesCondition implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LastPriceOnly")
    protected Boolean lastPriceOnly;

    @JsonProperty("StartDate")
    protected OffsetDateTime startDate;

    @JsonProperty("EndDate")
    protected OffsetDateTime endDate;

    @JsonProperty("LookBackPeriod")
    protected String lookBackPeriod;

    protected TimeSeriesCondition() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TimeSeriesCondition";
    }

    @Property(name="LastPriceOnly")
    @JsonIgnore
    public Optional<Boolean> getLastPriceOnly() {
        return Optional.ofNullable(lastPriceOnly);
    }

    public TimeSeriesCondition withLastPriceOnly(Boolean lastPriceOnly) {
        TimeSeriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TimeSeriesCondition");
        _x.lastPriceOnly = lastPriceOnly;
        return _x;
    }

    @Property(name="StartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public TimeSeriesCondition withStartDate(OffsetDateTime startDate) {
        TimeSeriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TimeSeriesCondition");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="EndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public TimeSeriesCondition withEndDate(OffsetDateTime endDate) {
        TimeSeriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TimeSeriesCondition");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="LookBackPeriod")
    @JsonIgnore
    public Optional<String> getLookBackPeriod() {
        return Optional.ofNullable(lookBackPeriod);
    }

    public TimeSeriesCondition withLookBackPeriod(String lookBackPeriod) {
        TimeSeriesCondition _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TimeSeriesCondition");
        _x.lookBackPeriod = lookBackPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean lastPriceOnly;
        private OffsetDateTime startDate;
        private OffsetDateTime endDate;
        private String lookBackPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder lastPriceOnly(Boolean lastPriceOnly) {
            this.lastPriceOnly = lastPriceOnly;
            this.changedFields = changedFields.add("LastPriceOnly");
            return this;
        }

        public Builder startDate(OffsetDateTime startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("StartDate");
            return this;
        }

        public Builder endDate(OffsetDateTime endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("EndDate");
            return this;
        }

        public Builder lookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            this.changedFields = changedFields.add("LookBackPeriod");
            return this;
        }

        public TimeSeriesCondition build() {
            TimeSeriesCondition _x = new TimeSeriesCondition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.TimeSeriesCondition";
            _x.lastPriceOnly = lastPriceOnly;
            _x.startDate = startDate;
            _x.endDate = endDate;
            _x.lookBackPeriod = lookBackPeriod;
            return _x;
        }
    }

    private TimeSeriesCondition _copy() {
        TimeSeriesCondition _x = new TimeSeriesCondition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.lastPriceOnly = lastPriceOnly;
        _x.startDate = startDate;
        _x.endDate = endDate;
        _x.lookBackPeriod = lookBackPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeSeriesCondition[");
        b.append("LastPriceOnly=");
        b.append(this.lastPriceOnly);
        b.append(", ");
        b.append("StartDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("EndDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("LookBackPeriod=");
        b.append(this.lookBackPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
