package thomsonreuters.dss.api.extractions.reporttemplates.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.entity.TypeBase;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ContentFieldFormatType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "FormatType", 
    "FieldGroup"})
public class ContentFieldType extends TypeBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldType";
    }

    @JsonProperty("FormatType")
    protected ContentFieldFormatType formatType;

    @JsonProperty("FieldGroup")
    protected String fieldGroup;

    protected ContentFieldType() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContentFieldType() {
        return new Builder();
    }

    public static final class Builder {
        private String code;
        private String name;
        private String description;
        private ContentFieldFormatType formatType;
        private String fieldGroup;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("Code");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder formatType(ContentFieldFormatType formatType) {
            this.formatType = formatType;
            this.changedFields = changedFields.add("FormatType");
            return this;
        }

        public Builder fieldGroup(String fieldGroup) {
            this.fieldGroup = fieldGroup;
            this.changedFields = changedFields.add("FieldGroup");
            return this;
        }

        public ContentFieldType build() {
            ContentFieldType _x = new ContentFieldType();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldType";
            _x.code = code;
            _x.name = name;
            _x.description = description;
            _x.formatType = formatType;
            _x.fieldGroup = fieldGroup;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && code != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(code.toString()));
        }
    }

    @Property(name="FormatType")
    @JsonIgnore
    public Optional<ContentFieldFormatType> getFormatType() {
        return Optional.ofNullable(formatType);
    }

    public ContentFieldType withFormatType(ContentFieldFormatType formatType) {
        ContentFieldType _x = _copy();
        _x.changedFields = changedFields.add("FormatType");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldType");
        _x.formatType = formatType;
        return _x;
    }

    @Property(name="FieldGroup")
    @JsonIgnore
    public Optional<String> getFieldGroup() {
        return Optional.ofNullable(fieldGroup);
    }

    public ContentFieldType withFieldGroup(String fieldGroup) {
        ContentFieldType _x = _copy();
        _x.changedFields = changedFields.add("FieldGroup");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ContentFieldType");
        _x.fieldGroup = fieldGroup;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContentFieldType patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ContentFieldType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContentFieldType put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ContentFieldType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ContentFieldType _copy() {
        ContentFieldType _x = new ContentFieldType();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.code = code;
        _x.name = name;
        _x.description = description;
        _x.formatType = formatType;
        _x.fieldGroup = fieldGroup;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentFieldType[");
        b.append("Code=");
        b.append(this.code);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("FormatType=");
        b.append(this.formatType);
        b.append(", ");
        b.append("FieldGroup=");
        b.append(this.fieldGroup);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
