package thomsonreuters.dss.api.extractions.reporttemplates.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentField;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.EstimatesActualCondition;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ReportHeaderField;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.ReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportCompressionType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDelimiter;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDeliveryType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportOutputFormat;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Condition"})
public class EstimatesActualReportTemplate extends ReportTemplate implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesActualReportTemplate";
    }

    @JsonProperty("Condition")
    protected EstimatesActualCondition condition;

    protected EstimatesActualReportTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEstimatesActualReportTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String reportTemplateId;
        private Boolean showColumnHeaders;
        private ReportCompressionType compressionType;
        private OffsetDateTime createDate;
        private OffsetDateTime lastChangedDate;
        private String name;
        private ReportOutputFormat outputFormat;
        private Integer reportFieldCount;
        private ReportDelimiter delimiter;
        private ReportDeliveryType deliveryType;
        private String destination;
        private String templateTypeCode;
        private List<ReportHeaderField> headers;
        private String headersNextLink;
        private List<ReportHeaderField> trailers;
        private String trailersNextLink;
        private List<ContentField> contentFields;
        private String contentFieldsNextLink;
        private EstimatesActualCondition condition;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportTemplateId(String reportTemplateId) {
            this.reportTemplateId = reportTemplateId;
            this.changedFields = changedFields.add("ReportTemplateId");
            return this;
        }

        public Builder showColumnHeaders(Boolean showColumnHeaders) {
            this.showColumnHeaders = showColumnHeaders;
            this.changedFields = changedFields.add("ShowColumnHeaders");
            return this;
        }

        public Builder compressionType(ReportCompressionType compressionType) {
            this.compressionType = compressionType;
            this.changedFields = changedFields.add("CompressionType");
            return this;
        }

        public Builder createDate(OffsetDateTime createDate) {
            this.createDate = createDate;
            this.changedFields = changedFields.add("CreateDate");
            return this;
        }

        public Builder lastChangedDate(OffsetDateTime lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
            this.changedFields = changedFields.add("LastChangedDate");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder outputFormat(ReportOutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            this.changedFields = changedFields.add("OutputFormat");
            return this;
        }

        public Builder reportFieldCount(Integer reportFieldCount) {
            this.reportFieldCount = reportFieldCount;
            this.changedFields = changedFields.add("ReportFieldCount");
            return this;
        }

        public Builder delimiter(ReportDelimiter delimiter) {
            this.delimiter = delimiter;
            this.changedFields = changedFields.add("Delimiter");
            return this;
        }

        public Builder deliveryType(ReportDeliveryType deliveryType) {
            this.deliveryType = deliveryType;
            this.changedFields = changedFields.add("DeliveryType");
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            this.changedFields = changedFields.add("Destination");
            return this;
        }

        public Builder templateTypeCode(String templateTypeCode) {
            this.templateTypeCode = templateTypeCode;
            this.changedFields = changedFields.add("TemplateTypeCode");
            return this;
        }

        public Builder headers(List<ReportHeaderField> headers) {
            this.headers = headers;
            this.changedFields = changedFields.add("Headers");
            return this;
        }

        public Builder headersNextLink(String headersNextLink) {
            this.headersNextLink = headersNextLink;
            this.changedFields = changedFields.add("Headers");
            return this;
        }

        public Builder trailers(List<ReportHeaderField> trailers) {
            this.trailers = trailers;
            this.changedFields = changedFields.add("Trailers");
            return this;
        }

        public Builder trailersNextLink(String trailersNextLink) {
            this.trailersNextLink = trailersNextLink;
            this.changedFields = changedFields.add("Trailers");
            return this;
        }

        public Builder contentFields(List<ContentField> contentFields) {
            this.contentFields = contentFields;
            this.changedFields = changedFields.add("ContentFields");
            return this;
        }

        public Builder contentFieldsNextLink(String contentFieldsNextLink) {
            this.contentFieldsNextLink = contentFieldsNextLink;
            this.changedFields = changedFields.add("ContentFields");
            return this;
        }

        public Builder condition(EstimatesActualCondition condition) {
            this.condition = condition;
            this.changedFields = changedFields.add("Condition");
            return this;
        }

        public EstimatesActualReportTemplate build() {
            EstimatesActualReportTemplate _x = new EstimatesActualReportTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesActualReportTemplate";
            _x.reportTemplateId = reportTemplateId;
            _x.showColumnHeaders = showColumnHeaders;
            _x.compressionType = compressionType;
            _x.createDate = createDate;
            _x.lastChangedDate = lastChangedDate;
            _x.name = name;
            _x.outputFormat = outputFormat;
            _x.reportFieldCount = reportFieldCount;
            _x.delimiter = delimiter;
            _x.deliveryType = deliveryType;
            _x.destination = destination;
            _x.templateTypeCode = templateTypeCode;
            _x.headers = headers;
            _x.headersNextLink = headersNextLink;
            _x.trailers = trailers;
            _x.trailersNextLink = trailersNextLink;
            _x.contentFields = contentFields;
            _x.contentFieldsNextLink = contentFieldsNextLink;
            _x.condition = condition;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && reportTemplateId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(reportTemplateId.toString()));
        }
    }

    @Property(name="Condition")
    @JsonIgnore
    public Optional<EstimatesActualCondition> getCondition() {
        return Optional.ofNullable(condition);
    }

    public EstimatesActualReportTemplate withCondition(EstimatesActualCondition condition) {
        EstimatesActualReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("Condition");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.EstimatesActualReportTemplate");
        _x.condition = condition;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EstimatesActualReportTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EstimatesActualReportTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EstimatesActualReportTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EstimatesActualReportTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EstimatesActualReportTemplate _copy() {
        EstimatesActualReportTemplate _x = new EstimatesActualReportTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportTemplateId = reportTemplateId;
        _x.showColumnHeaders = showColumnHeaders;
        _x.compressionType = compressionType;
        _x.createDate = createDate;
        _x.lastChangedDate = lastChangedDate;
        _x.name = name;
        _x.outputFormat = outputFormat;
        _x.reportFieldCount = reportFieldCount;
        _x.delimiter = delimiter;
        _x.deliveryType = deliveryType;
        _x.destination = destination;
        _x.templateTypeCode = templateTypeCode;
        _x.headers = headers;
        _x.trailers = trailers;
        _x.contentFields = contentFields;
        _x.condition = condition;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EstimatesActualReportTemplate[");
        b.append("ReportTemplateId=");
        b.append(this.reportTemplateId);
        b.append(", ");
        b.append("ShowColumnHeaders=");
        b.append(this.showColumnHeaders);
        b.append(", ");
        b.append("CompressionType=");
        b.append(this.compressionType);
        b.append(", ");
        b.append("CreateDate=");
        b.append(this.createDate);
        b.append(", ");
        b.append("LastChangedDate=");
        b.append(this.lastChangedDate);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("OutputFormat=");
        b.append(this.outputFormat);
        b.append(", ");
        b.append("ReportFieldCount=");
        b.append(this.reportFieldCount);
        b.append(", ");
        b.append("Delimiter=");
        b.append(this.delimiter);
        b.append(", ");
        b.append("DeliveryType=");
        b.append(this.deliveryType);
        b.append(", ");
        b.append("Destination=");
        b.append(this.destination);
        b.append(", ");
        b.append("TemplateTypeCode=");
        b.append(this.templateTypeCode);
        b.append(", ");
        b.append("Headers=");
        b.append(this.headers);
        b.append(", ");
        b.append("Trailers=");
        b.append(this.trailers);
        b.append(", ");
        b.append("ContentFields=");
        b.append(this.contentFields);
        b.append(", ");
        b.append("Condition=");
        b.append(this.condition);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
