package thomsonreuters.dss.api.extractions.reporttemplates.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reporttemplates.complex.ContentField;
import thomsonreuters.dss.api.extractions.reporttemplates.complex.ReportHeaderField;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ReportTemplateTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportCompressionType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDelimiter;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportDeliveryType;
import thomsonreuters.dss.api.extractions.reporttemplates.enums.ReportOutputFormat;
import thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.schedules.collection.request.ScheduleCollectionRequest;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ReportTemplateId", 
    "ShowColumnHeaders", 
    "CompressionType", 
    "CreateDate", 
    "LastChangedDate", 
    "Name", 
    "OutputFormat", 
    "ReportFieldCount", 
    "Delimiter", 
    "DeliveryType", 
    "Destination", 
    "TemplateTypeCode", 
    "Headers", 
    "Trailers", 
    "ContentFields"})
public class ReportTemplate implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ReportTemplateId")
    protected String reportTemplateId;

    @JsonProperty("ShowColumnHeaders")
    protected Boolean showColumnHeaders;

    @JsonProperty("CompressionType")
    protected ReportCompressionType compressionType;

    @JsonProperty("CreateDate")
    protected OffsetDateTime createDate;

    @JsonProperty("LastChangedDate")
    protected OffsetDateTime lastChangedDate;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("OutputFormat")
    protected ReportOutputFormat outputFormat;

    @JsonProperty("ReportFieldCount")
    protected Integer reportFieldCount;

    @JsonProperty("Delimiter")
    protected ReportDelimiter delimiter;

    @JsonProperty("DeliveryType")
    protected ReportDeliveryType deliveryType;

    @JsonProperty("Destination")
    protected String destination;

    @JsonProperty("TemplateTypeCode")
    protected String templateTypeCode;

    @JsonProperty("Headers")
    protected List<ReportHeaderField> headers;

    @JsonProperty("Headers@nextLink")
    protected String headersNextLink;

    @JsonProperty("Trailers")
    protected List<ReportHeaderField> trailers;

    @JsonProperty("Trailers@nextLink")
    protected String trailersNextLink;

    @JsonProperty("ContentFields")
    protected List<ContentField> contentFields;

    @JsonProperty("ContentFields@nextLink")
    protected String contentFieldsNextLink;

    protected ReportTemplate() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String reportTemplateId;
        private Boolean showColumnHeaders;
        private ReportCompressionType compressionType;
        private OffsetDateTime createDate;
        private OffsetDateTime lastChangedDate;
        private String name;
        private ReportOutputFormat outputFormat;
        private Integer reportFieldCount;
        private ReportDelimiter delimiter;
        private ReportDeliveryType deliveryType;
        private String destination;
        private String templateTypeCode;
        private List<ReportHeaderField> headers;
        private String headersNextLink;
        private List<ReportHeaderField> trailers;
        private String trailersNextLink;
        private List<ContentField> contentFields;
        private String contentFieldsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder reportTemplateId(String reportTemplateId) {
            this.reportTemplateId = reportTemplateId;
            this.changedFields = changedFields.add("ReportTemplateId");
            return this;
        }

        public Builder showColumnHeaders(Boolean showColumnHeaders) {
            this.showColumnHeaders = showColumnHeaders;
            this.changedFields = changedFields.add("ShowColumnHeaders");
            return this;
        }

        public Builder compressionType(ReportCompressionType compressionType) {
            this.compressionType = compressionType;
            this.changedFields = changedFields.add("CompressionType");
            return this;
        }

        public Builder createDate(OffsetDateTime createDate) {
            this.createDate = createDate;
            this.changedFields = changedFields.add("CreateDate");
            return this;
        }

        public Builder lastChangedDate(OffsetDateTime lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
            this.changedFields = changedFields.add("LastChangedDate");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder outputFormat(ReportOutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            this.changedFields = changedFields.add("OutputFormat");
            return this;
        }

        public Builder reportFieldCount(Integer reportFieldCount) {
            this.reportFieldCount = reportFieldCount;
            this.changedFields = changedFields.add("ReportFieldCount");
            return this;
        }

        public Builder delimiter(ReportDelimiter delimiter) {
            this.delimiter = delimiter;
            this.changedFields = changedFields.add("Delimiter");
            return this;
        }

        public Builder deliveryType(ReportDeliveryType deliveryType) {
            this.deliveryType = deliveryType;
            this.changedFields = changedFields.add("DeliveryType");
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            this.changedFields = changedFields.add("Destination");
            return this;
        }

        public Builder templateTypeCode(String templateTypeCode) {
            this.templateTypeCode = templateTypeCode;
            this.changedFields = changedFields.add("TemplateTypeCode");
            return this;
        }

        public Builder headers(List<ReportHeaderField> headers) {
            this.headers = headers;
            this.changedFields = changedFields.add("Headers");
            return this;
        }

        public Builder headersNextLink(String headersNextLink) {
            this.headersNextLink = headersNextLink;
            this.changedFields = changedFields.add("Headers");
            return this;
        }

        public Builder trailers(List<ReportHeaderField> trailers) {
            this.trailers = trailers;
            this.changedFields = changedFields.add("Trailers");
            return this;
        }

        public Builder trailersNextLink(String trailersNextLink) {
            this.trailersNextLink = trailersNextLink;
            this.changedFields = changedFields.add("Trailers");
            return this;
        }

        public Builder contentFields(List<ContentField> contentFields) {
            this.contentFields = contentFields;
            this.changedFields = changedFields.add("ContentFields");
            return this;
        }

        public Builder contentFieldsNextLink(String contentFieldsNextLink) {
            this.contentFieldsNextLink = contentFieldsNextLink;
            this.changedFields = changedFields.add("ContentFields");
            return this;
        }

        public ReportTemplate build() {
            ReportTemplate _x = new ReportTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate";
            _x.reportTemplateId = reportTemplateId;
            _x.showColumnHeaders = showColumnHeaders;
            _x.compressionType = compressionType;
            _x.createDate = createDate;
            _x.lastChangedDate = lastChangedDate;
            _x.name = name;
            _x.outputFormat = outputFormat;
            _x.reportFieldCount = reportFieldCount;
            _x.delimiter = delimiter;
            _x.deliveryType = deliveryType;
            _x.destination = destination;
            _x.templateTypeCode = templateTypeCode;
            _x.headers = headers;
            _x.headersNextLink = headersNextLink;
            _x.trailers = trailers;
            _x.trailersNextLink = trailersNextLink;
            _x.contentFields = contentFields;
            _x.contentFieldsNextLink = contentFieldsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && reportTemplateId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(reportTemplateId.toString()));
        }
    }

    @Property(name="ReportTemplateId")
    @JsonIgnore
    public Optional<String> getReportTemplateId() {
        return Optional.ofNullable(reportTemplateId);
    }

    public ReportTemplate withReportTemplateId(String reportTemplateId) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("ReportTemplateId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.reportTemplateId = reportTemplateId;
        return _x;
    }

    @Property(name="ShowColumnHeaders")
    @JsonIgnore
    public Optional<Boolean> getShowColumnHeaders() {
        return Optional.ofNullable(showColumnHeaders);
    }

    public ReportTemplate withShowColumnHeaders(Boolean showColumnHeaders) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("ShowColumnHeaders");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.showColumnHeaders = showColumnHeaders;
        return _x;
    }

    @Property(name="CompressionType")
    @JsonIgnore
    public Optional<ReportCompressionType> getCompressionType() {
        return Optional.ofNullable(compressionType);
    }

    public ReportTemplate withCompressionType(ReportCompressionType compressionType) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("CompressionType");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.compressionType = compressionType;
        return _x;
    }

    @Property(name="CreateDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreateDate() {
        return Optional.ofNullable(createDate);
    }

    public ReportTemplate withCreateDate(OffsetDateTime createDate) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("CreateDate");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.createDate = createDate;
        return _x;
    }

    @Property(name="LastChangedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastChangedDate() {
        return Optional.ofNullable(lastChangedDate);
    }

    public ReportTemplate withLastChangedDate(OffsetDateTime lastChangedDate) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("LastChangedDate");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.lastChangedDate = lastChangedDate;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ReportTemplate withName(String name) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("Name");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.name = name;
        return _x;
    }

    @Property(name="OutputFormat")
    @JsonIgnore
    public Optional<ReportOutputFormat> getOutputFormat() {
        return Optional.ofNullable(outputFormat);
    }

    public ReportTemplate withOutputFormat(ReportOutputFormat outputFormat) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("OutputFormat");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.outputFormat = outputFormat;
        return _x;
    }

    @Property(name="ReportFieldCount")
    @JsonIgnore
    public Optional<Integer> getReportFieldCount() {
        return Optional.ofNullable(reportFieldCount);
    }

    public ReportTemplate withReportFieldCount(Integer reportFieldCount) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("ReportFieldCount");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.reportFieldCount = reportFieldCount;
        return _x;
    }

    @Property(name="Delimiter")
    @JsonIgnore
    public Optional<ReportDelimiter> getDelimiter() {
        return Optional.ofNullable(delimiter);
    }

    public ReportTemplate withDelimiter(ReportDelimiter delimiter) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("Delimiter");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.delimiter = delimiter;
        return _x;
    }

    @Property(name="DeliveryType")
    @JsonIgnore
    public Optional<ReportDeliveryType> getDeliveryType() {
        return Optional.ofNullable(deliveryType);
    }

    public ReportTemplate withDeliveryType(ReportDeliveryType deliveryType) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("DeliveryType");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.deliveryType = deliveryType;
        return _x;
    }

    @Property(name="Destination")
    @JsonIgnore
    public Optional<String> getDestination() {
        return Optional.ofNullable(destination);
    }

    public ReportTemplate withDestination(String destination) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("Destination");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.destination = destination;
        return _x;
    }

    @Property(name="TemplateTypeCode")
    @JsonIgnore
    public Optional<String> getTemplateTypeCode() {
        return Optional.ofNullable(templateTypeCode);
    }

    public ReportTemplate withTemplateTypeCode(String templateTypeCode) {
        ReportTemplate _x = _copy();
        _x.changedFields = changedFields.add("TemplateTypeCode");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplate");
        _x.templateTypeCode = templateTypeCode;
        return _x;
    }

    @Property(name="Headers")
    @JsonIgnore
    public CollectionPage<ReportHeaderField> getHeaders() {
        return new CollectionPage<ReportHeaderField>(contextPath, ReportHeaderField.class, headers, Optional.ofNullable(headersNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Trailers")
    @JsonIgnore
    public CollectionPage<ReportHeaderField> getTrailers() {
        return new CollectionPage<ReportHeaderField>(contextPath, ReportHeaderField.class, trailers, Optional.ofNullable(trailersNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="ContentFields")
    @JsonIgnore
    public CollectionPage<ContentField> getContentFields() {
        return new CollectionPage<ContentField>(contextPath, ContentField.class, contentFields, Optional.ofNullable(contentFieldsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @NavigationProperty(name="Type")
    @JsonIgnore
    public ReportTemplateTypeEntityRequest getType() {
        return new ReportTemplateTypeEntityRequest(contextPath.addSegment("Type"));
    }

    @NavigationProperty(name="Schedules")
    @JsonIgnore
    public ScheduleCollectionRequest getSchedules() {
        return new ScheduleCollectionRequest(
                        contextPath.addSegment("Schedules"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReportTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ReportTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReportTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ReportTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ReportTemplate _copy() {
        ReportTemplate _x = new ReportTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.reportTemplateId = reportTemplateId;
        _x.showColumnHeaders = showColumnHeaders;
        _x.compressionType = compressionType;
        _x.createDate = createDate;
        _x.lastChangedDate = lastChangedDate;
        _x.name = name;
        _x.outputFormat = outputFormat;
        _x.reportFieldCount = reportFieldCount;
        _x.delimiter = delimiter;
        _x.deliveryType = deliveryType;
        _x.destination = destination;
        _x.templateTypeCode = templateTypeCode;
        _x.headers = headers;
        _x.trailers = trailers;
        _x.contentFields = contentFields;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReportTemplate[");
        b.append("ReportTemplateId=");
        b.append(this.reportTemplateId);
        b.append(", ");
        b.append("ShowColumnHeaders=");
        b.append(this.showColumnHeaders);
        b.append(", ");
        b.append("CompressionType=");
        b.append(this.compressionType);
        b.append(", ");
        b.append("CreateDate=");
        b.append(this.createDate);
        b.append(", ");
        b.append("LastChangedDate=");
        b.append(this.lastChangedDate);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("OutputFormat=");
        b.append(this.outputFormat);
        b.append(", ");
        b.append("ReportFieldCount=");
        b.append(this.reportFieldCount);
        b.append(", ");
        b.append("Delimiter=");
        b.append(this.delimiter);
        b.append(", ");
        b.append("DeliveryType=");
        b.append(this.deliveryType);
        b.append(", ");
        b.append("Destination=");
        b.append(this.destination);
        b.append(", ");
        b.append("TemplateTypeCode=");
        b.append(this.templateTypeCode);
        b.append(", ");
        b.append("Headers=");
        b.append(this.headers);
        b.append(", ");
        b.append("Trailers=");
        b.append(this.trailers);
        b.append(", ");
        b.append("ContentFields=");
        b.append(this.contentFields);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
