package thomsonreuters.dss.api.extractions.reporttemplates.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.complex.ExtractionLimit;
import thomsonreuters.dss.api.extractions.entity.TypeBase;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Limit", 
    "Permissions"})
public class ReportTemplateType extends TypeBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplateType";
    }

    @JsonProperty("Limit")
    protected ExtractionLimit limit;

    @JsonProperty("Permissions")
    protected List<String> permissions;

    @JsonProperty("Permissions@nextLink")
    protected String permissionsNextLink;

    protected ReportTemplateType() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderReportTemplateType() {
        return new Builder();
    }

    public static final class Builder {
        private String code;
        private String name;
        private String description;
        private ExtractionLimit limit;
        private List<String> permissions;
        private String permissionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("Code");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder limit(ExtractionLimit limit) {
            this.limit = limit;
            this.changedFields = changedFields.add("Limit");
            return this;
        }

        public Builder permissions(List<String> permissions) {
            this.permissions = permissions;
            this.changedFields = changedFields.add("Permissions");
            return this;
        }

        public Builder permissionsNextLink(String permissionsNextLink) {
            this.permissionsNextLink = permissionsNextLink;
            this.changedFields = changedFields.add("Permissions");
            return this;
        }

        public ReportTemplateType build() {
            ReportTemplateType _x = new ReportTemplateType();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplateType";
            _x.code = code;
            _x.name = name;
            _x.description = description;
            _x.limit = limit;
            _x.permissions = permissions;
            _x.permissionsNextLink = permissionsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && code != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(code.toString()));
        }
    }

    @Property(name="Limit")
    @JsonIgnore
    public Optional<ExtractionLimit> getLimit() {
        return Optional.ofNullable(limit);
    }

    public ReportTemplateType withLimit(ExtractionLimit limit) {
        ReportTemplateType _x = _copy();
        _x.changedFields = changedFields.add("Limit");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.ReportTemplates.ReportTemplateType");
        _x.limit = limit;
        return _x;
    }

    @Property(name="Permissions")
    @JsonIgnore
    public CollectionPage<String> getPermissions() {
        return new CollectionPage<String>(contextPath, String.class, permissions, Optional.ofNullable(permissionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReportTemplateType patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ReportTemplateType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ReportTemplateType put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ReportTemplateType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ReportTemplateType _copy() {
        ReportTemplateType _x = new ReportTemplateType();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.code = code;
        _x.name = name;
        _x.description = description;
        _x.limit = limit;
        _x.permissions = permissions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReportTemplateType[");
        b.append("Code=");
        b.append(this.code);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("Limit=");
        b.append(this.limit);
        b.append(", ");
        b.append("Permissions=");
        b.append(this.permissions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
