package thomsonreuters.dss.api.extractions.reporttemplates.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.reporttemplates.entity.ReportTemplate;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ReportTemplateTypeEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.schedules.collection.request.ScheduleCollectionRequest;
import thomsonreuters.dss.api.extractions.schedules.entity.request.ScheduleEntityRequest;

@JsonIgnoreType
public class ReportTemplateEntityRequest extends EntityRequest<ReportTemplate> {

    public ReportTemplateEntityRequest(ContextPath contextPath) {
        super(ReportTemplate.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ReportTemplateTypeEntityRequest type() {
        return new ReportTemplateTypeEntityRequest(contextPath.addSegment("Type"));
    }

    public ScheduleCollectionRequest schedules() {
        return new ScheduleCollectionRequest(
                        contextPath.addSegment("Schedules"));
    }

    public ScheduleEntityRequest schedules(String scheduleId) {
        return new ScheduleEntityRequest(contextPath.addSegment("Schedules").addKeys(new NameValue(scheduleId.toString())));
    }

}
