package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ContentFieldCapitalizationType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("LowerCase")
    LOWER_CASE("LowerCase", "1"),

    @JsonProperty("NameCase")
    NAME_CASE("NameCase", "2"),

    @JsonProperty("UpperCase")
    UPPER_CASE("UpperCase", "3");

    private final String name;
    private final String value;

    private ContentFieldCapitalizationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
