package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ContentFieldDecimalSeparator implements Enum {

    @JsonProperty("Comma")
    COMMA("Comma", "0"),

    @JsonProperty("Period")
    PERIOD("Period", "1");

    private final String name;
    private final String value;

    private ContentFieldDecimalSeparator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
