package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ContentFieldFormatType implements Enum {

    @JsonProperty("Text")
    TEXT("Text", "0"),

    @JsonProperty("Number")
    NUMBER("Number", "1"),

    @JsonProperty("Date")
    DATE("Date", "2");

    private final String name;
    private final String value;

    private ContentFieldFormatType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
