package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ContentFieldJustification implements Enum {

    @JsonProperty("Center")
    CENTER("Center", "0"),

    @JsonProperty("Left")
    LEFT("Left", "1"),

    @JsonProperty("Right")
    RIGHT("Right", "2");

    private final String name;
    private final String value;

    private ContentFieldJustification(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
