package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ContentFieldNegativeSignPosition implements Enum {

    @JsonProperty("Before")
    BEFORE("Before", "0"),

    @JsonProperty("After")
    AFTER("After", "1"),

    @JsonProperty("Parentheses")
    PARENTHESES("Parentheses", "2");

    private final String name;
    private final String value;

    private ContentFieldNegativeSignPosition(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
