package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ContentFieldThousandsSeparator implements Enum {

    @JsonProperty("Comma")
    COMMA("Comma", "0"),

    @JsonProperty("Period")
    PERIOD("Period", "1"),

    @JsonProperty("Space")
    SPACE("Space", "2"),

    @JsonProperty("None")
    NONE("None", "3");

    private final String name;
    private final String value;

    private ContentFieldThousandsSeparator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
