package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ContentFieldWidthStyle implements Enum {

    @JsonProperty("VariableWidth")
    VARIABLE_WIDTH("VariableWidth", "0"),

    @JsonProperty("FixedWidth")
    FIXED_WIDTH("FixedWidth", "1");

    private final String name;
    private final String value;

    private ContentFieldWidthStyle(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
