package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CorporateActionsCapitalChangeType implements Enum {

    @JsonProperty("CapitalChangeAnnouncementDate")
    CAPITAL_CHANGE_ANNOUNCEMENT_DATE("CapitalChangeAnnouncementDate", "0"),

    @JsonProperty("CapitalChangeDealDate")
    CAPITAL_CHANGE_DEAL_DATE("CapitalChangeDealDate", "1"),

    @JsonProperty("CapitalChangeExDate")
    CAPITAL_CHANGE_EX_DATE("CapitalChangeExDate", "2"),

    @JsonProperty("EffectiveDate")
    EFFECTIVE_DATE("EffectiveDate", "3"),

    @JsonProperty("RecordDate")
    RECORD_DATE("RecordDate", "4");

    private final String name;
    private final String value;

    private CorporateActionsCapitalChangeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
