package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CorporateActionsDividendsType implements Enum {

    @JsonProperty("DividendAnnouncementDate")
    DIVIDEND_ANNOUNCEMENT_DATE("DividendAnnouncementDate", "0"),

    @JsonProperty("DividendExDate")
    DIVIDEND_EX_DATE("DividendExDate", "1"),

    @JsonProperty("DividendPayDate")
    DIVIDEND_PAY_DATE("DividendPayDate", "2"),

    @JsonProperty("DividendRecordDate")
    DIVIDEND_RECORD_DATE("DividendRecordDate", "3"),

    @JsonProperty("PeriodEndDate")
    PERIOD_END_DATE("PeriodEndDate", "4");

    private final String name;
    private final String value;

    private CorporateActionsDividendsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
