package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CorporateActionsEarningsType implements Enum {

    @JsonProperty("EarningsAnnouncementDate")
    EARNINGS_ANNOUNCEMENT_DATE("EarningsAnnouncementDate", "0"),

    @JsonProperty("PeriodEndDate")
    PERIOD_END_DATE("PeriodEndDate", "1");

    private final String name;
    private final String value;

    private CorporateActionsEarningsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
