package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CorporateActionsEquityOfferingsType implements Enum {

    @JsonProperty("AllPendingDeals")
    ALL_PENDING_DEALS("AllPendingDeals", "0"),

    @JsonProperty("FirstTradingDate")
    FIRST_TRADING_DATE("FirstTradingDate", "1");

    private final String name;
    private final String value;

    private CorporateActionsEquityOfferingsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
