package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CorporateActionsMergersAcquisitionsType implements Enum {

    @JsonProperty("DealAnnouncementDate")
    DEAL_ANNOUNCEMENT_DATE("DealAnnouncementDate", "0"),

    @JsonProperty("DealCancelDate")
    DEAL_CANCEL_DATE("DealCancelDate", "1"),

    @JsonProperty("DealCloseDate")
    DEAL_CLOSE_DATE("DealCloseDate", "2"),

    @JsonProperty("DealEffectiveDate")
    DEAL_EFFECTIVE_DATE("DealEffectiveDate", "3"),

    @JsonProperty("DealRevisedProposalDate")
    DEAL_REVISED_PROPOSAL_DATE("DealRevisedProposalDate", "4"),

    @JsonProperty("TenderOfferExpirationDate")
    TENDER_OFFER_EXPIRATION_DATE("TenderOfferExpirationDate", "5");

    private final String name;
    private final String value;

    private CorporateActionsMergersAcquisitionsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
