package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CorporateActionsNominalValueType implements Enum {

    @JsonProperty("NominalValueDate")
    NOMINAL_VALUE_DATE("NominalValueDate", "0");

    private final String name;
    private final String value;

    private CorporateActionsNominalValueType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
