package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CorporateActionsStandardEventsType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("CAP")
    CAP("CAP", "1"),

    @JsonProperty("DIV")
    DIV("DIV", "2"),

    @JsonProperty("EAR")
    EAR("EAR", "3"),

    @JsonProperty("MNA")
    MNA("MNA", "4"),

    @JsonProperty("NOM")
    NOM("NOM", "5"),

    @JsonProperty("PEO")
    PEO("PEO", "6"),

    @JsonProperty("SHO")
    SHO("SHO", "7"),

    @JsonProperty("VOT")
    VOT("VOT", "8");

    private final String name;
    private final String value;

    private CorporateActionsStandardEventsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
