package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CorporateActionsStandardYearType implements Enum {

    @JsonProperty("Current")
    CURRENT("Current", "0"),

    @JsonProperty("Y2013")
    Y2013("Y2013", "1"),

    @JsonProperty("Y2012")
    Y2012("Y2012", "2"),

    @JsonProperty("Y2011")
    Y2011("Y2011", "3"),

    @JsonProperty("Previous")
    PREVIOUS("Previous", "4");

    private final String name;
    private final String value;

    private CorporateActionsStandardYearType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
