package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EstimateType implements Enum {

    @JsonProperty("BPS")
    BPS("BPS", "0"),

    @JsonProperty("CPS")
    CPS("CPS", "1"),

    @JsonProperty("CPX")
    CPX("CPX", "2"),

    @JsonProperty("CSH")
    CSH("CSH", "3"),

    @JsonProperty("DPS")
    DPS("DPS", "4"),

    @JsonProperty("EBG")
    EBG("EBG", "5"),

    @JsonProperty("EBI")
    EBI("EBI", "6"),

    @JsonProperty("EBS")
    EBS("EBS", "7"),

    @JsonProperty("EBT")
    EBT("EBT", "8"),

    @JsonProperty("ENT")
    ENT("ENT", "9"),

    @JsonProperty("EPS")
    EPS("EPS", "10"),

    @JsonProperty("EPX")
    EPX("EPX", "11"),

    @JsonProperty("FFO")
    FFO("FFO", "12"),

    @JsonProperty("GPS")
    GPS("GPS", "13"),

    @JsonProperty("GRM")
    GRM("GRM", "14"),

    @JsonProperty("NAV")
    NAV("NAV", "15"),

    @JsonProperty("NDT")
    NDT("NDT", "16"),

    @JsonProperty("NET")
    NET("NET", "17"),

    @JsonProperty("OPR")
    OPR("OPR", "18"),

    @JsonProperty("PRE")
    PRE("PRE", "19"),

    @JsonProperty("PTG")
    PTG("PTG", "20"),

    @JsonProperty("REC")
    REC("REC", "21"),

    @JsonProperty("ROA")
    ROA("ROA", "22"),

    @JsonProperty("ROE")
    ROE("ROE", "23"),

    @JsonProperty("SAL")
    SAL("SAL", "24");

    private final String name;
    private final String value;

    private EstimateType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
