package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FixedIncomeRatingSource implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Fitch")
    FITCH("Fitch", "1"),

    @JsonProperty("Moodys")
    MOODYS("Moodys", "2"),

    @JsonProperty("StandardAndPoors")
    STANDARD_AND_POORS("StandardAndPoors", "4");

    private final String name;
    private final String value;

    private FixedIncomeRatingSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
