package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FundAllocationTypes implements Enum {

    @JsonProperty("Asset")
    ASSET("Asset", "0"),

    @JsonProperty("InvestmentCountry")
    INVESTMENT_COUNTRY("InvestmentCountry", "1"),

    @JsonProperty("Currency")
    CURRENCY("Currency", "2"),

    @JsonProperty("IndustrySector")
    INDUSTRY_SECTOR("IndustrySector", "3"),

    @JsonProperty("TopTenHoldings")
    TOP_TEN_HOLDINGS("TopTenHoldings", "4"),

    @JsonProperty("FullHoldings")
    FULL_HOLDINGS("FullHoldings", "5");

    private final String name;
    private final String value;

    private FundAllocationTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
