package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum HistoricalFiscalYearType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("FYNegative1")
    FYNEGATIVE1("FYNegative1", "1"),

    @JsonProperty("FYNegative2")
    FYNEGATIVE2("FYNegative2", "2"),

    @JsonProperty("FYNegative3")
    FYNEGATIVE3("FYNegative3", "3"),

    @JsonProperty("FYNegative4")
    FYNEGATIVE4("FYNegative4", "4"),

    @JsonProperty("FYNegative5")
    FYNEGATIVE5("FYNegative5", "5");

    private final String name;
    private final String value;

    private HistoricalFiscalYearType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
