package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum HistoricalQuarterType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("QNegative1")
    QNEGATIVE1("QNegative1", "1"),

    @JsonProperty("QNegative2")
    QNEGATIVE2("QNegative2", "2"),

    @JsonProperty("QNegative3")
    QNEGATIVE3("QNegative3", "3"),

    @JsonProperty("QNegative4")
    QNEGATIVE4("QNegative4", "4"),

    @JsonProperty("QNegative5")
    QNEGATIVE5("QNegative5", "5"),

    @JsonProperty("QNegative6")
    QNEGATIVE6("QNegative6", "6"),

    @JsonProperty("QNegative7")
    QNEGATIVE7("QNegative7", "7"),

    @JsonProperty("QNegative8")
    QNEGATIVE8("QNegative8", "8");

    private final String name;
    private final String value;

    private HistoricalQuarterType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
