package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum HistoricalSemiAnnualType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("SNegative1")
    SNEGATIVE1("SNegative1", "1"),

    @JsonProperty("SNegative2")
    SNEGATIVE2("SNegative2", "2"),

    @JsonProperty("SNegative3")
    SNEGATIVE3("SNegative3", "3"),

    @JsonProperty("SNegative4")
    SNEGATIVE4("SNegative4", "4");

    private final String name;
    private final String value;

    private HistoricalSemiAnnualType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
