package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum IssuerAssetClassType implements Enum {

    @JsonProperty("AllSupportedAssets")
    ALL_SUPPORTED_ASSETS("AllSupportedAssets", "0"),

    @JsonProperty("GovernmentAndCorporateBonds")
    GOVERNMENT_AND_CORPORATE_BONDS("GovernmentAndCorporateBonds", "1"),

    @JsonProperty("Equities")
    EQUITIES("Equities", "2");

    private final String name;
    private final String value;

    private IssuerAssetClassType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
