package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LookbackType implements Enum {

    @JsonProperty("OneMonth")
    ONE_MONTH("OneMonth", "0"),

    @JsonProperty("ThreeMonths")
    THREE_MONTHS("ThreeMonths", "1"),

    @JsonProperty("FourMonths")
    FOUR_MONTHS("FourMonths", "2"),

    @JsonProperty("SixMonths")
    SIX_MONTHS("SixMonths", "3"),

    @JsonProperty("TwelveMonths")
    TWELVE_MONTHS("TwelveMonths", "4");

    private final String name;
    private final String value;

    private LookbackType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
