package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum NewsAnalyticsNoveltyType implements Enum {

    @JsonProperty("NoveltyNone")
    NOVELTY_NONE("NoveltyNone", "0"),

    @JsonProperty("Novelty12Hr")
    NOVELTY12HR("Novelty12Hr", "1"),

    @JsonProperty("Novelty24Hr")
    NOVELTY24HR("Novelty24Hr", "2"),

    @JsonProperty("Novelty3Day")
    NOVELTY3DAY("Novelty3Day", "3"),

    @JsonProperty("Novelty5Day")
    NOVELTY5DAY("Novelty5Day", "4"),

    @JsonProperty("Novelty7Day")
    NOVELTY7DAY("Novelty7Day", "5"),

    @JsonProperty("NoveltyAll")
    NOVELTY_ALL("NoveltyAll", "6");

    private final String name;
    private final String value;

    private NewsAnalyticsNoveltyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
